/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.jta.template;

import com.atomikos.icatch.jta.template.TransactionTemplate;
import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionManager;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.Callable;

class RequiredTemplate
extends TransactionTemplate {
    protected RequiredTemplate(TransactionManager utm, int timeout) {
        super(utm, timeout);
    }

    @Override
    public <T> T execute(Callable<T> work) throws Exception {
        T ret = null;
        boolean transactionStartedHere = false;
        try {
            if (this.utm.getTransaction() == null) {
                this.beginTransaction();
                transactionStartedHere = true;
            }
            ret = work.call();
            if (transactionStartedHere) {
                this.utm.commit();
            }
        }
        catch (Exception e) {
            this.handleException(transactionStartedHere);
            throw e;
        }
        catch (Throwable e) {
            this.handleException(transactionStartedHere);
            throw new UndeclaredThrowableException(e);
        }
        return ret;
    }

    private void handleException(boolean transactionStartedHere) throws SystemException {
        if (transactionStartedHere) {
            this.utm.rollback();
        } else {
            this.utm.setRollbackOnly();
        }
    }
}

