/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.jta.template;

import com.atomikos.icatch.jta.UserTransactionManager;
import com.atomikos.icatch.jta.template.MandatoryTemplate;
import com.atomikos.icatch.jta.template.NestedTemplate;
import com.atomikos.icatch.jta.template.NeverTemplate;
import com.atomikos.icatch.jta.template.NotSupportedTemplate;
import com.atomikos.icatch.jta.template.RequiredTemplate;
import com.atomikos.icatch.jta.template.RequiresNewTemplate;
import com.atomikos.icatch.jta.template.SupportsTemplate;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import java.util.concurrent.Callable;

public class TransactionTemplate {
    private int timeout;
    protected TransactionManager utm;

    public TransactionTemplate() {
        this(new UserTransactionManager(), 0);
    }

    TransactionTemplate(TransactionManager utm, int timeout) {
        this.timeout = timeout;
        this.utm = utm;
    }

    public TransactionTemplate withTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public TransactionTemplate required() {
        return new RequiredTemplate(this.utm, this.timeout);
    }

    public TransactionTemplate nested() {
        return new NestedTemplate(this.utm, this.timeout);
    }

    protected Transaction beginTransaction() throws Exception {
        this.utm.setTransactionTimeout(this.timeout);
        this.utm.begin();
        return this.utm.getTransaction();
    }

    public <T> T execute(Callable<T> work) throws Exception {
        return new RequiredTemplate(this.utm, this.timeout).execute(work);
    }

    public TransactionTemplate requiresNew() {
        return new RequiresNewTemplate(this.utm, this.timeout);
    }

    public TransactionTemplate mandatory() {
        return new MandatoryTemplate(this.utm, this.timeout);
    }

    public TransactionTemplate never() {
        return new NeverTemplate(this.utm, this.timeout);
    }

    public TransactionTemplate supports() {
        return new SupportsTemplate(this.utm, this.timeout);
    }

    public TransactionTemplate notSupported() {
        return new NotSupportedTemplate(this.utm, this.timeout);
    }
}

