/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.beans;

import com.atomikos.beans.AbstractPropertyEditorComponent;
import com.atomikos.beans.IndexedProperty;
import com.atomikos.beans.IndexedPropertyTableModel;
import com.atomikos.beans.PrimitiveClasses;
import com.atomikos.beans.PropertyException;
import com.atomikos.swing.PropertiesPanel;
import com.atomikos.swing.PropertiesTableModel;
import com.atomikos.swing.PropertyListener;
import java.awt.Component;
import java.lang.reflect.Array;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TableComponent
extends AbstractPropertyEditorComponent
implements PropertyListener {
    private Vector data_;
    private PropertiesPanel panel_;
    private IndexedProperty property_;

    private static Object constructNewObject(Class clazz) throws PropertyException {
        String ret = null;
        JPanel panel = new JPanel();
        JTextField text = null;
        JCheckBox checkbox = null;
        Class wrapperClass = PrimitiveClasses.getWrapperClass(clazz);
        if (wrapperClass == null && !clazz.equals(String.class)) {
            throw new PropertyException("Not a supported class: " + clazz.getName(), null);
        }
        if (wrapperClass != null && wrapperClass.equals(Boolean.class)) {
            checkbox = new JCheckBox("Check if true", false);
            panel.add(checkbox);
        } else {
            text = new JTextField("Enter value");
            panel.add(text);
        }
        int answer = JOptionPane.showConfirmDialog(null, panel, "New Element Property", 2, -1);
        if (answer == 0) {
            ret = checkbox != null ? new Boolean(checkbox.isSelected()).toString() : text.getText();
        }
        return ret;
    }

    public TableComponent(IndexedProperty property) throws PropertyException {
        this.property_ = property;
        Object[] data = (Object[])property.getValue();
        this.data_ = new Vector();
        for (int i = 0; i < data.length; ++i) {
            this.data_.addElement(data[i]);
        }
        IndexedPropertyTableModel table = new IndexedPropertyTableModel(this.data_, property.getName());
        this.panel_ = new PropertiesPanel(table, false);
        this.panel_.getPanel().setToolTipText(property.getDescription());
        this.panel_.addPropertyListener(this);
    }

    public Component getComponent() {
        return this.panel_.getPanel();
    }

    public void newProperty(PropertiesTableModel table) {
        Object object = null;
        try {
            object = TableComponent.constructNewObject(this.property_.getIndexedType());
        }
        catch (PropertyException pe) {
            throw new RuntimeException(pe.getMessage());
        }
        if (object != null) {
            this.data_.addElement(object);
            table.rowInserted();
            Object value = Array.newInstance(this.property_.getIndexedType(), this.data_.size());
            this.getPropertyEditor().setValue(value);
        }
    }

    public void deleteProperty(PropertiesTableModel table, int index) {
        Object toDelete = this.data_.elementAt(index);
        this.data_.remove(toDelete);
        table.rowDeleted(index);
        Object value = Array.newInstance(this.property_.getIndexedType(), this.data_.size());
        this.getPropertyEditor().setValue(value);
    }

    public void editProperty(PropertiesTableModel table, int index) {
        JOptionPane.showMessageDialog(null, "To edit, please delete and create a new value...");
    }
}

