/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.tcc.rest;

import com.atomikos.icatch.config.Configuration;
import com.atomikos.icatch.tcc.rest.CoordinatorImp;
import com.atomikos.icatch.tcc.rest.TransactionProvider;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;

public class Server {
    private String url;
    private JAXRSServerFactoryBean sf;

    public Server(String url) {
        this.url = url;
    }

    public void start() {
        this.startTransactionCore();
        this.startCoordinatorService();
    }

    private void startCoordinatorService() {
        CoordinatorImp coord = new CoordinatorImp();
        this.sf = new JAXRSServerFactoryBean();
        ArrayList<Object> providers = new ArrayList<Object>();
        providers.add(new JacksonJaxbJsonProvider());
        providers.add(new TransactionProvider());
        this.sf.setProviders(providers);
        this.sf.setResourceClasses(new Class[]{CoordinatorImp.class});
        this.sf.setResourceProvider(CoordinatorImp.class, (ResourceProvider)new SingletonResourceProvider((Object)coord));
        this.sf.setAddress(this.url);
        this.sf.create();
    }

    private void startTransactionCore() {
        Configuration.init();
    }

    public void stop(boolean force) {
        this.shutdownCxf();
        this.shutdownTransactionCore(force);
    }

    private void shutdownTransactionCore(boolean force) {
        Configuration.shutdown((boolean)force);
    }

    private void shutdownCxf() {
        if (this.sf != null) {
            this.sf.getBus().shutdown(true);
        }
        this.sf = null;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Required argument: Port to start on");
            System.exit(1);
        }
        Server server = Server.startServer(args);
        System.out.println("Server running - type ENTER to terminate...");
        Server.waitForEnter();
        System.out.println("Server stopping, waiting for ongoing transactions to finish...");
        server.stop(false);
        System.out.println("Server stopped.");
    }

    private static void waitForEnter() throws IOException {
        InputStream in = System.in;
        InputStreamReader r = new InputStreamReader(in);
        BufferedReader br = new BufferedReader(r);
        br.readLine();
    }

    private static Server startServer(String[] args) {
        String port = args[0];
        Server server = new Server("http://localhost:" + port);
        server.start();
        return server;
    }
}

