/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.persistence.imp;

import com.atomikos.diagnostics.Console;
import com.atomikos.persistence.LogException;
import com.atomikos.persistence.LogStream;
import com.atomikos.util.VersionedFile;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.StreamCorruptedException;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;

public class FileLogStream
implements LogStream {
    private FileOutputStream output_;
    private ObjectOutputStream ooutput_;
    private boolean simulateCrash_;
    private Console console_;
    private boolean corrupt_;
    private VersionedFile file_;

    public FileLogStream(String baseDir, String baseName, Console console) throws IOException {
        this.file_ = new VersionedFile(baseDir, baseName, ".log");
        this.simulateCrash_ = false;
        this.console_ = console;
        this.corrupt_ = false;
    }

    private void closeOutput() throws LogException {
        Stack errors = new Stack();
        try {
            if (this.file_ != null) {
                this.file_.close();
                if (this.console_ != null) {
                    this.console_.println("Logfile closed: " + this.file_.getCurrentVersionFileName());
                }
            }
            this.output_ = null;
            this.ooutput_ = null;
        }
        catch (IOException e) {
            errors = new Stack();
            throw new LogException("Error closing previous output", errors);
        }
    }

    void setCrashMode() {
        this.simulateCrash_ = true;
    }

    public synchronized Vector recover() throws LogException {
        if (this.corrupt_) {
            throw new LogException("Instance might be corrupted");
        }
        Stack<Exception> errors = new Stack<Exception>();
        Vector<Object> ret = new Vector<Object>();
        FileInputStream in = null;
        try {
            FileInputStream f;
            in = f = this.file_.openLastValidVersionForReading();
            ObjectInputStream ins = new ObjectInputStream(in);
            int count = 0;
            if (this.console_ != null) {
                this.console_.println("Starting read of logfile " + this.file_.getCurrentVersionFileName());
            }
            while (((InputStream)in).available() > 0) {
                Object nxt = ins.readObject();
                ret.addElement(nxt);
                if (++count % 10 != 0 || this.console_ == null) continue;
                this.console_.print(".");
            }
            if (this.console_ != null) {
                this.console_.println("Done read of logfile");
            }
        }
        catch (EOFException unexpectedEOF) {
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            catch (IOException io) {
                errors.push(io);
                throw new LogException("Error in recover", errors);
            }
        }
        catch (StreamCorruptedException unexpectedEOF) {
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            catch (IOException io) {
                errors.push(io);
                throw new LogException("Error in recover", errors);
            }
        }
        catch (ObjectStreamException unexpectedEOF) {
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            catch (IOException io) {
                errors.push(io);
                throw new LogException("Error in recover", errors);
            }
        }
        catch (FileNotFoundException firstStart) {
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            catch (IOException io) {
                errors.push(io);
                throw new LogException("Error in recover", errors);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.err.println(e.getClass().getName());
            e.printStackTrace();
            errors.push(e);
            throw new LogException("Error in recover", errors);
        }
        finally {
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            catch (IOException io) {
                errors.push(io);
                throw new LogException("Error in recover", errors);
            }
        }
        return ret;
    }

    public synchronized void writeCheckpoint(Enumeration elements) throws LogException {
        Stack<Exception> errors = new Stack<Exception>();
        this.closeOutput();
        try {
            this.output_ = this.file_.openNewVersionForWriting();
            this.ooutput_ = new ObjectOutputStream(this.output_);
            while (elements != null && elements.hasMoreElements()) {
                Object next = elements.nextElement();
                this.ooutput_.writeObject(next);
            }
            this.ooutput_.flush();
            this.output_.flush();
            this.output_.getFD().sync();
            if (this.simulateCrash_) {
                this.corrupt_ = true;
                throw new LogException("Old file could not be deleted");
            }
            try {
                this.file_.discardBackupVersion();
            }
            catch (IOException errorOnDelete) {
                this.corrupt_ = true;
                throw new LogException("Old file could not be deleted");
            }
        }
        catch (Exception e) {
            errors.push(e);
            throw new LogException("Error during checkpointing", errors);
        }
    }

    public synchronized void flushObject(Object o, boolean shouldSync) throws LogException {
        if (this.ooutput_ == null) {
            throw new LogException("Not Initialized or already closed");
        }
        try {
            this.ooutput_.writeObject(o);
            this.output_.flush();
            this.ooutput_.flush();
            if (shouldSync) {
                this.output_.getFD().sync();
            }
        }
        catch (IOException e) {
            Stack errors = new Stack();
            throw new LogException(e.getMessage(), errors);
        }
    }

    public synchronized void close() throws LogException {
        this.closeOutput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public long getSize() throws LogException {
        return this.file_.getSize();
    }
}

