/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.HeurCommitException;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TxState;
import com.atomikos.icatch.admin.AdminTransaction;
import com.atomikos.icatch.imp.CoordinatorImp;
import java.util.Stack;

class AdminTransactionImp
implements AdminTransaction {
    private CoordinatorImp coord_;

    static int convertState(Object state) {
        int ret = -1;
        if (state.equals(TxState.ACTIVE)) {
            ret = -3;
        } else if (state.equals(TxState.PREPARING)) {
            ret = -2;
        } else if (state.equals(TxState.IN_DOUBT)) {
            ret = 0;
        } else if (state.equals(TxState.HEUR_MIXED)) {
            ret = 4;
        } else if (state.equals(TxState.HEUR_HAZARD)) {
            ret = 3;
        } else if (state.equals(TxState.HEUR_COMMITTED)) {
            ret = 1;
        } else if (state.equals(TxState.HEUR_ABORTED)) {
            ret = 2;
        } else if (state.equals(TxState.COMMITTING)) {
            ret = 6;
        } else if (state.equals(TxState.ABORTING)) {
            ret = 5;
        } else if (state.equals(TxState.TERMINATED)) {
            ret = 7;
        }
        return ret;
    }

    static Object convertState(int state) {
        TxState ret = null;
        switch (state) {
            case 0: {
                ret = TxState.IN_DOUBT;
                break;
            }
            case 4: {
                ret = TxState.HEUR_MIXED;
                break;
            }
            case 3: {
                ret = TxState.HEUR_HAZARD;
                break;
            }
            case 1: {
                ret = TxState.HEUR_COMMITTED;
                break;
            }
            case 2: {
                ret = TxState.HEUR_ABORTED;
                break;
            }
            case 6: {
                ret = TxState.COMMITTING;
                break;
            }
            case 5: {
                ret = TxState.ABORTING;
                break;
            }
            case 7: {
                ret = TxState.TERMINATED;
                break;
            }
        }
        return ret;
    }

    AdminTransactionImp(CoordinatorImp coord) {
        this.coord_ = coord;
    }

    public String getTid() {
        return this.coord_.getCoordinatorId();
    }

    public boolean wasCommitted() {
        return this.coord_.isCommitted();
    }

    public int getState() {
        Object state = this.coord_.getState();
        return AdminTransactionImp.convertState(state);
    }

    public HeuristicMessage[] getTags() {
        return this.coord_.getTags();
    }

    public HeuristicMessage[] getHeuristicMessages() {
        return this.coord_.getHeuristicMessages();
    }

    public HeuristicMessage[] getHeuristicMessages(int state) {
        HeuristicMessage[] ret = null;
        Object txstate = AdminTransactionImp.convertState(state);
        if (txstate != null) {
            ret = this.coord_.getHeuristicMessages(txstate);
        }
        return ret;
    }

    public void forceCommit() throws HeurRollbackException, HeurHazardException, HeurMixedException, SysException {
        try {
            this.coord_.commitHeuristically();
        }
        catch (RollbackException rb) {
            Stack<RollbackException> errors = new Stack<RollbackException>();
            errors.push(rb);
            throw new SysException("Error in forced commit: " + rb.getMessage(), errors);
        }
    }

    public void forceRollback() throws HeurCommitException, HeurMixedException, HeurHazardException, SysException {
        this.coord_.rollbackHeuristically();
    }

    public void forceForget() {
        this.coord_.forget();
    }
}

