/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.system;

import com.atomikos.datasource.RecoverableResource;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.ExportingTransactionManager;
import com.atomikos.icatch.ImportingTransactionManager;
import com.atomikos.icatch.RecoveryService;
import com.atomikos.icatch.TSListener;
import com.atomikos.icatch.TransactionService;
import com.atomikos.icatch.admin.LogAdministrator;
import com.atomikos.icatch.admin.LogControl;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public final class Configuration {
    private static final Logger LOGGER = LoggerFactory.createLogger(Configuration.class);
    private static CompositeTransactionManager ctxmgr_ = null;
    private static ImportingTransactionManager imptxmgr_ = null;
    private static ExportingTransactionManager exptxmgr_ = null;
    private static Hashtable resources_ = new Hashtable();
    private static Vector resourceList_ = new Vector();
    private static Vector logAdministrators_ = new Vector();
    private static LogControl logControl_;
    private static RecoveryService recoveryService_;
    private static TransactionService service_;
    private static Vector tsListenersList_;
    private static List shutdownHooks_;

    private static void purgeResources() {
        Enumeration enumm = Configuration.getResources();
        while (enumm.hasMoreElements()) {
            RecoverableResource res = (RecoverableResource)enumm.nextElement();
            if (!res.isClosed()) continue;
            Configuration.removeResource(res.getName());
        }
    }

    private Configuration() {
    }

    public static synchronized void installTransactionService(TransactionService service) {
        service_ = service;
        Iterator it = tsListenersList_.iterator();
        while (it.hasNext() && service != null) {
            TSListener l = (TSListener)it.next();
            service_.addTSListener(l);
        }
    }

    public static synchronized void addShutdownHook(Thread hook) {
        if (shutdownHooks_.contains(hook)) {
            return;
        }
        shutdownHooks_.add(hook);
        try {
            Runtime.getRuntime().addShutdownHook(hook);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static synchronized void removeShutdownHooks() {
        Iterator it = shutdownHooks_.iterator();
        boolean vmShutdown = false;
        while (it.hasNext()) {
            Thread t = (Thread)it.next();
            if (!t.equals(Thread.currentThread())) continue;
            vmShutdown = true;
        }
        it = shutdownHooks_.iterator();
        while (!vmShutdown && it.hasNext()) {
            Thread hook = (Thread)it.next();
            it.remove();
            try {
                Runtime.getRuntime().removeShutdownHook(hook);
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }

    public static TransactionService getTransactionService() {
        return service_;
    }

    public static synchronized void addTSListener(TSListener l) {
        if (service_ != null) {
            service_.addTSListener(l);
        }
        tsListenersList_.add(l);
    }

    public static synchronized void removeTSListener(TSListener l) {
        if (service_ != null) {
            service_.removeTSListener(l);
        }
        tsListenersList_.remove(l);
    }

    public static synchronized void installCompositeTransactionManager(CompositeTransactionManager compositeTransactionManager) {
        ctxmgr_ = compositeTransactionManager;
    }

    public static synchronized void installRecoveryService(RecoveryService service) {
        recoveryService_ = service;
        if (service != null) {
            Enumeration resources = Configuration.getResources();
            while (resources.hasMoreElements()) {
                RecoverableResource next = (RecoverableResource)resources.nextElement();
                next.setRecoveryService(service);
            }
        }
    }

    public static synchronized void installLogControl(LogControl control) {
        logControl_ = control;
        if (logControl_ != null) {
            Enumeration enumm = Configuration.getLogAdministrators();
            while (enumm.hasMoreElements()) {
                LogAdministrator admin = (LogAdministrator)enumm.nextElement();
                admin.registerLogControl(control);
            }
        }
    }

    public static synchronized void installImportingTransactionManager(ImportingTransactionManager importingTransactionManager) {
        imptxmgr_ = importingTransactionManager;
    }

    public static synchronized void installExportingTransactionManager(ExportingTransactionManager exportingTransactionManager) {
        exptxmgr_ = exportingTransactionManager;
    }

    public static CompositeTransactionManager getCompositeTransactionManager() {
        return ctxmgr_;
    }

    public static ImportingTransactionManager getImportingTransactionManager() {
        return imptxmgr_;
    }

    public static ExportingTransactionManager getExportingTransactionManager() {
        return exptxmgr_;
    }

    public static synchronized void addResource(RecoverableResource resource) throws IllegalStateException {
        Configuration.purgeResources();
        int numResources = resources_.size();
        if (numResources > 100) {
            LOGGER.logWarning(numResources + " RESOURCES IN CONFIGURATION -- " + "SOME XARESOURCE IMPLEMENTATIONS MAY NOT CORRECTLY IMPLEMENT isSameRM()!");
            LOGGER.logWarning("TO SAVE MEMORY, USE EXPLICIT RESOURCE REGISTRATION MODE.");
        }
        if (resources_.containsKey(resource.getName())) {
            throw new IllegalStateException("Attempt to register second resource with name " + resource.getName());
        }
        LOGGER.logDebug("Configuration: adding resource " + resource.getName());
        resources_.put(resource.getName(), resource);
        resourceList_.add(resource);
        resource.setRecoveryService(recoveryService_);
        LOGGER.logDebug("Configuration: added resource " + resource.getName());
    }

    public static synchronized void addLogAdministrator(LogAdministrator admin) {
        if (logAdministrators_.contains(admin)) {
            return;
        }
        logAdministrators_.add(admin);
        if (logControl_ != null) {
            admin.registerLogControl(logControl_);
        }
    }

    public static void removeLogAdministrator(LogAdministrator admin) {
        logAdministrators_.remove(admin);
        if (logControl_ != null) {
            admin.deregisterLogControl(logControl_);
        }
    }

    public static Enumeration getLogAdministrators() {
        Vector v = (Vector)logAdministrators_.clone();
        return v.elements();
    }

    public static RecoverableResource removeResource(String name) {
        RecoverableResource ret = null;
        if (name != null && (ret = (RecoverableResource)resources_.remove(name)) != null) {
            resourceList_.remove(ret);
        }
        LOGGER.logDebug("Configuration: removed resource " + name);
        return ret;
    }

    public static RecoverableResource getResource(String name) {
        RecoverableResource res = null;
        if (name != null) {
            res = (RecoverableResource)resources_.get(name);
        }
        return res;
    }

    public static Enumeration getResources() {
        Vector ret = (Vector)resourceList_.clone();
        return ret.elements();
    }

    static {
        tsListenersList_ = new Vector();
        shutdownHooks_ = new ArrayList();
    }
}

