/*
 * Decompiled with CFR 0.152.
 */
package com.audienceproject.spark.dynamodb.catalyst;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class JavaConverter$ {
    public static JavaConverter$ MODULE$;

    static {
        new JavaConverter$();
    }

    public Object convertRowValue(InternalRow row, int index, DataType elementType) {
        Object object;
        DataType dataType = elementType;
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType innerType = arrayType.elementType();
            object = this.convertArray(row.getArray(index), innerType);
        } else if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            object = this.convertMap(row.getMap(index), keyType, valueType);
        } else if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            object = this.convertStruct(row.getStruct(index, fields.length), (Seq<StructField>)Predef$.MODULE$.wrapRefArray((Object[])fields));
        } else if (StringType$.MODULE$.equals(dataType)) {
            object = row.getString(index);
        } else if (LongType$.MODULE$.equals(dataType)) {
            object = BoxesRunTime.boxToLong((long)row.getLong(index));
        } else if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            object = row.getDecimal(index, decimalType.precision(), decimalType.scale()).toBigDecimal();
        } else {
            object = row.get(index, elementType);
        }
        return object;
    }

    public Object convertArray(ArrayData array, DataType elementType) {
        Object object;
        DataType dataType = elementType;
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType innerType = arrayType.elementType();
            object = JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)array.toSeq(elementType).map((Function1 & Serializable & scala.Serializable)x$1 -> MODULE$.convertArray((ArrayData)x$1, innerType), IndexedSeq$.MODULE$.canBuildFrom())).asJava();
        } else if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            object = JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)array.toSeq(elementType).map((Function1 & Serializable & scala.Serializable)x$2 -> MODULE$.convertMap((MapData)x$2, keyType, valueType), IndexedSeq$.MODULE$.canBuildFrom())).asJava();
        } else if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            object = JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)array.toSeq((DataType)structType).map((Function1 & Serializable & scala.Serializable)x$3 -> MODULE$.convertStruct((InternalRow)x$3, (Seq<StructField>)Predef$.MODULE$.wrapRefArray((Object[])structType.fields())), IndexedSeq$.MODULE$.canBuildFrom())).asJava();
        } else {
            object = StringType$.MODULE$.equals(dataType) ? JavaConverters$.MODULE$.seqAsJavaListConverter(this.convertStringArray(array)).asJava() : JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)array.toSeq(elementType)).asJava();
        }
        return object;
    }

    public java.util.Map<String, Object> convertMap(MapData map, DataType keyType, DataType valueType) {
        IndexedSeq indexedSeq;
        DataType dataType = keyType;
        StringType$ stringType$ = StringType$.MODULE$;
        if (dataType == null ? stringType$ != null : !dataType.equals(stringType$)) {
            throw new IllegalArgumentException(new StringBuilder(71).append("Invalid Map key type '").append(keyType.typeName()).append("'. DynamoDB only supports String as Map key type.").toString());
        }
        Seq<String> keys = this.convertStringArray(map.keyArray());
        DataType dataType2 = valueType;
        if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType innerType = arrayType.elementType();
            indexedSeq = (IndexedSeq)map.valueArray().toSeq(valueType).map((Function1 & Serializable & scala.Serializable)x$4 -> MODULE$.convertArray((ArrayData)x$4, innerType), IndexedSeq$.MODULE$.canBuildFrom());
        } else if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType innerKeyType = mapType.keyType();
            DataType innerValueType = mapType.valueType();
            indexedSeq = (Seq)map.valueArray().toSeq(valueType).map((Function1 & Serializable & scala.Serializable)x$5 -> MODULE$.convertMap((MapData)x$5, innerKeyType, innerValueType), IndexedSeq$.MODULE$.canBuildFrom());
        } else if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            indexedSeq = (Seq)map.valueArray().toSeq((DataType)structType).map((Function1 & Serializable & scala.Serializable)x$6 -> MODULE$.convertStruct((InternalRow)x$6, (Seq<StructField>)Predef$.MODULE$.wrapRefArray((Object[])structType.fields())), IndexedSeq$.MODULE$.canBuildFrom());
        } else {
            indexedSeq = StringType$.MODULE$.equals(dataType2) ? this.convertStringArray(map.valueArray()) : map.valueArray().toSeq(valueType);
        }
        IndexedSeq values = indexedSeq;
        scala.collection.immutable.IndexedSeq kvPairs = (scala.collection.immutable.IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), map.numElements()).map(arg_0 -> JavaConverter$.$anonfun$convertMap$4$adapted(keys, (Seq)values, arg_0), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom());
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)kvPairs)).asJava();
    }

    public java.util.Map<String, Object> convertStruct(InternalRow row, Seq<StructField> fields) {
        scala.collection.immutable.IndexedSeq kvPairs = (scala.collection.immutable.IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), row.numFields()).map((Function1 & Serializable & scala.Serializable)i -> JavaConverter$.$anonfun$convertStruct$1(row, fields, BoxesRunTime.unboxToInt((Object)i)), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom());
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)kvPairs)).asJava();
    }

    public Seq<String> convertStringArray(ArrayData array) {
        return (Seq)array.toSeq((DataType)StringType$.MODULE$).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.toString(), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ Tuple2 $anonfun$convertStruct$1(InternalRow row$1, Seq fields$1, int i) {
        return row$1.isNullAt(i) ? Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((StructField)fields$1.apply(i)).name()), null) : Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((StructField)fields$1.apply(i)).name()), MODULE$.convertRowValue(row$1, i, ((StructField)fields$1.apply(i)).dataType()));
    }

    private JavaConverter$() {
        MODULE$ = this;
    }

    public static final /* synthetic */ Tuple2 $anonfun$convertMap$4$adapted(Seq keys$1, Seq values$1, Object i) {
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(keys$1.apply(BoxesRunTime.unboxToInt((Object)i))), values$1.apply(BoxesRunTime.unboxToInt((Object)i)));
    }
}

