/*
 * Decompiled with CFR 0.152.
 */
package com.audienceproject.spark.dynamodb.connector;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDBAsync;
import com.amazonaws.services.dynamodbv2.document.AttributeUpdate;
import com.amazonaws.services.dynamodbv2.document.BatchWriteItemOutcome;
import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import com.amazonaws.services.dynamodbv2.document.Item;
import com.amazonaws.services.dynamodbv2.document.ItemCollection;
import com.amazonaws.services.dynamodbv2.document.ScanOutcome;
import com.amazonaws.services.dynamodbv2.document.Table;
import com.amazonaws.services.dynamodbv2.document.TableWriteItems;
import com.amazonaws.services.dynamodbv2.document.UpdateItemOutcome;
import com.amazonaws.services.dynamodbv2.document.spec.BatchWriteItemSpec;
import com.amazonaws.services.dynamodbv2.document.spec.ScanSpec;
import com.amazonaws.services.dynamodbv2.document.spec.UpdateItemSpec;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.ReturnConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import com.amazonaws.services.dynamodbv2.xspec.ExpressionSpecBuilder;
import com.audienceproject.shaded.google.common.util.concurrent.RateLimiter;
import com.audienceproject.spark.dynamodb.catalyst.JavaConverter$;
import com.audienceproject.spark.dynamodb.connector.ColumnSchema;
import com.audienceproject.spark.dynamodb.connector.DynamoConnector;
import com.audienceproject.spark.dynamodb.connector.DynamoWritable;
import com.audienceproject.spark.dynamodb.connector.FilterPushdown$;
import com.audienceproject.spark.dynamodb.connector.KeySchema;
import com.audienceproject.spark.dynamodb.connector.KeySchema$;
import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.sys.SystemProperties;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\u0005Uh!B\u0011#\u0001\u0011b\u0003\u0002C\u001f\u0001\u0005\u0003\u0005\u000b\u0011B \t\u0011)\u0003!\u0011!Q\u0001\n-C\u0001B\u0014\u0001\u0003\u0002\u0003\u0006Ia\u0014\u0005\u0006%\u0002!\ta\u0015\u0005\b1\u0002\u0011\r\u0011\"\u0003Z\u0011\u0019i\u0006\u0001)A\u00055\"9a\f\u0001b\u0001\n\u0013I\u0006BB0\u0001A\u0003%!\fC\u0004a\u0001\t\u0007I\u0011B1\t\r\u0015\u0004\u0001\u0015!\u0003c\u0011\u001d1\u0007A1A\u0005\n\u0005Daa\u001a\u0001!\u0002\u0013\u0011\u0007b\u00025\u0001\u0005\u0004%I!\u0019\u0005\u0007S\u0002\u0001\u000b\u0011\u00022\t\u000f)\u0004!\u0019!C!3\"11\u000e\u0001Q\u0001\niC!\u0002\u001c\u0001\u0011\u0002\u0003\r\t\u0015!\u0003n\u0011\u001d1\bA1A\u0005B]Da\u0001\u001f\u0001!\u0002\u0013\u0001\bbB=\u0001\u0005\u0004%\tE\u001f\u0005\u0007w\u0002\u0001\u000b\u0011B:\t\u000fq\u0004!\u0019!C!u\"1Q\u0010\u0001Q\u0001\nMDqA \u0001C\u0002\u0013\u0005s\u0010C\u0004\u0002\u0002\u0001\u0001\u000b\u0011B&\t\u0011\u0005\r\u0001A1A\u0005B}Dq!!\u0002\u0001A\u0003%1\nC\u0004\u0002\b\u0001!\t%!\u0003\t\u000f\u0005\r\u0004\u0001\"\u0011\u0002f!9\u0011Q\u0017\u0001\u0005B\u0005]\u0006bBAc\u0001\u0011\u0005\u0013q\u0019\u0005\b\u0003'\u0004A\u0011BAk\u00059!\u0016M\u00197f\u0007>tg.Z2u_JT!a\t\u0013\u0002\u0013\r|gN\\3di>\u0014(BA\u0013'\u0003!!\u0017P\\1n_\u0012\u0014'BA\u0014)\u0003\u0015\u0019\b/\u0019:l\u0015\tI#&A\bbk\u0012LWM\\2faJ|'.Z2u\u0015\u0005Y\u0013aA2p[N)\u0001!L\u001a8uA\u0011a&M\u0007\u0002_)\t\u0001'A\u0003tG\u0006d\u0017-\u0003\u00023_\t1\u0011I\\=SK\u001a\u0004\"\u0001N\u001b\u000e\u0003\tJ!A\u000e\u0012\u0003\u001f\u0011Kh.Y7p\u0007>tg.Z2u_J\u0004\"\u0001\u000e\u001d\n\u0005e\u0012#A\u0004#z]\u0006lwn\u0016:ji\u0006\u0014G.\u001a\t\u0003]mJ!\u0001P\u0018\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u0013Q\f'\r\\3OC6,7\u0001\u0001\t\u0003\u0001\u001es!!Q#\u0011\u0005\t{S\"A\"\u000b\u0005\u0011s\u0014A\u0002\u001fs_>$h(\u0003\u0002G_\u00051\u0001K]3eK\u001aL!\u0001S%\u0003\rM#(/\u001b8h\u0015\t1u&A\u0006qCJ\fG\u000e\\3mSNl\u0007C\u0001\u0018M\u0013\tiuFA\u0002J]R\f!\u0002]1sC6,G/\u001a:t!\u0011\u0001\u0005kP \n\u0005EK%aA'ba\u00061A(\u001b8jiz\"B\u0001V+W/B\u0011A\u0007\u0001\u0005\u0006{\u0011\u0001\ra\u0010\u0005\u0006\u0015\u0012\u0001\ra\u0013\u0005\u0006\u001d\u0012\u0001\raT\u0001\u000fG>t7/[:uK:$(+Z1e+\u0005Q\u0006C\u0001\u0018\\\u0013\tavFA\u0004C_>dW-\u00198\u0002\u001f\r|gn]5ti\u0016tGOU3bI\u0002\naBZ5mi\u0016\u0014\b+^:iI><h.A\bgS2$XM\u001d)vg\"$wn\u001e8!\u0003\u0019\u0011XmZ5p]V\t!\rE\u0002/G~J!\u0001Z\u0018\u0003\r=\u0003H/[8o\u0003\u001d\u0011XmZ5p]\u0002\nqA]8mK\u0006\u0013h.\u0001\u0005s_2,\u0017I\u001d8!\u0003E\u0001(o\u001c<jI\u0016\u00148\t\\1tg:\u000bW.Z\u0001\u0013aJ|g/\u001b3fe\u000ec\u0017m]:OC6,\u0007%A\u000bgS2$XM\u001d)vg\"$wn\u001e8F]\u0006\u0014G.\u001a3\u0002-\u0019LG\u000e^3s!V\u001c\b\u000eZ8x]\u0016s\u0017M\u00197fI\u0002\n1\u0001\u001f\u00137!\u001dqc\u000e]:t\u0017.K!a\\\u0018\u0003\rQ+\b\u000f\\36!\t!\u0014/\u0003\u0002sE\tI1*Z=TG\",W.\u0019\t\u0003]QL!!^\u0018\u0003\r\u0011{WO\u00197f\u0003%YW-_*dQ\u0016l\u0017-F\u0001q\u0003)YW-_*dQ\u0016l\u0017\rI\u0001\ne\u0016\fG\rT5nSR,\u0012a]\u0001\u000be\u0016\fG\rT5nSR\u0004\u0013AC<sSR,G*[7ji\u0006YqO]5uK2KW.\u001b;!\u0003%IG/Z7MS6LG/F\u0001L\u0003)IG/Z7MS6LG\u000fI\u0001\u000ei>$\u0018\r\\*fO6,g\u000e^:\u0002\u001dQ|G/\u00197TK\u001elWM\u001c;tA\u0005!1oY1o)!\tY!!\u000b\u0002.\u0005\r\u0003CBA\u0007\u0003?\t\u0019#\u0004\u0002\u0002\u0010)!\u0011\u0011CA\n\u0003!!wnY;nK:$(\u0002BA\u000b\u0003/\t!\u0002Z=oC6|GM\u0019<3\u0015\u0011\tI\"a\u0007\u0002\u0011M,'O^5dKNT1!!\b+\u0003%\tW.\u0019>p]\u0006<8/\u0003\u0003\u0002\"\u0005=!AD%uK6\u001cu\u000e\u001c7fGRLwN\u001c\t\u0005\u0003\u001b\t)#\u0003\u0003\u0002(\u0005=!aC*dC:|U\u000f^2p[\u0016Da!a\u000b\u001d\u0001\u0004Y\u0015AC:fO6,g\u000e\u001e(v[\"9\u0011q\u0006\u000fA\u0002\u0005E\u0012aB2pYVlgn\u001d\t\u0006\u0003g\tid\u0010\b\u0005\u0003k\tIDD\u0002C\u0003oI\u0011\u0001M\u0005\u0004\u0003wy\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003\u007f\t\tEA\u0002TKFT1!a\u000f0\u0011\u001d\t)\u0005\ba\u0001\u0003\u000f\nqAZ5mi\u0016\u00148\u000f\u0005\u0004\u00024\u0005u\u0012\u0011\n\t\u0005\u0003\u0017\ny&\u0004\u0002\u0002N)!\u0011qJA)\u0003\u001d\u0019x.\u001e:dKNTA!a\u0015\u0002V\u0005\u00191/\u001d7\u000b\u0007\u001d\n9F\u0003\u0003\u0002Z\u0005m\u0013AB1qC\u000eDWM\u0003\u0002\u0002^\u0005\u0019qN]4\n\t\u0005\u0005\u0014Q\n\u0002\u0007\r&dG/\u001a:\u0002\u0011A,H/\u0013;f[N$b!a\u001a\u0002\u001a\u0006\rFCBA5\u0003_\nI\bE\u0002/\u0003WJ1!!\u001c0\u0005\u0011)f.\u001b;\t\u000f\u0005ET\u00041\u0001\u0002t\u000511\r\\5f]R\u0004B!!\u0004\u0002v%!\u0011qOA\b\u0005!!\u0015P\\1n_\u0012\u0013\u0005bBA>;\u0001\u0007\u0011QP\u0001\fe\u0006$X\rT5nSR,'\u000f\u0005\u0003\u0002\u0000\u0005UUBAAA\u0015\u0011\t\u0019)!\"\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0002\b\u0006%\u0015\u0001B;uS2TA!a#\u0002\u000e\u000611m\\7n_:TA!a$\u0002\u0012\u00061qm\\8hY\u0016T1!a%)\u0003\u0019\u0019\b.\u00193fI&!\u0011qSAA\u0005-\u0011\u0016\r^3MS6LG/\u001a:\t\u000f\u0005mU\u00041\u0001\u0002\u001e\u0006a1m\u001c7v[:\u001c6\r[3nCB\u0019A'a(\n\u0007\u0005\u0005&E\u0001\u0007D_2,XN\\*dQ\u0016l\u0017\rC\u0004\u0002&v\u0001\r!a*\u0002\u000b%$X-\\:\u0011\r\u0005M\u0012QHAU!\u0011\tY+!-\u000e\u0005\u00055&\u0002BAX\u0003#\n\u0001bY1uC2L8\u000f^\u0005\u0005\u0003g\u000biKA\u0006J]R,'O\\1m%><\u0018AC;qI\u0006$X-\u0013;f[R1\u0011\u0011XA`\u0003\u0003$b!!\u001b\u0002<\u0006u\u0006bBA9=\u0001\u0007\u00111\u000f\u0005\b\u0003wr\u0002\u0019AA?\u0011\u001d\tYJ\ba\u0001\u0003;Cq!a1\u001f\u0001\u0004\tI+A\u0002s_^\f1\u0002Z3mKR,\u0017\n^3ngR1\u0011\u0011ZAh\u0003#$b!!\u001b\u0002L\u00065\u0007bBA9?\u0001\u0007\u00111\u000f\u0005\b\u0003wz\u0002\u0019AA?\u0011\u001d\tYj\ba\u0001\u0003;Cq!!* \u0001\u0004\t9+\u0001\riC:$G.\u001a\"bi\u000eDwK]5uKJ+7\u000f]8og\u0016$b!a6\u0002d\u0006\u0015H\u0003BA5\u00033Dq!a7!\u0001\u0004\ti.\u0001\u0005sKN\u0004xN\\:f!\u0011\ti!a8\n\t\u0005\u0005\u0018q\u0002\u0002\u0016\u0005\u0006$8\r[,sSR,\u0017\n^3n\u001fV$8m\\7f\u0011\u001d\t\t\b\ta\u0001\u0003gBq!a\u001f!\u0001\u0004\ti\bK\u0002!\u0003S\u0004B!a;\u0002r6\u0011\u0011Q\u001e\u0006\u0004\u0003_|\u0013AC1o]>$\u0018\r^5p]&!\u00111_Aw\u0005\u001d!\u0018-\u001b7sK\u000e\u0004")
public class TableConnector
implements DynamoConnector,
DynamoWritable,
scala.Serializable {
    private final String tableName;
    private final int parallelism;
    private final boolean consistentRead;
    private final boolean filterPushdown;
    private final Option<String> region;
    private final Option<String> roleArn;
    private final Option<String> providerClassName;
    private final boolean filterPushdownEnabled;
    private final /* synthetic */ Tuple5 x$6;
    private final KeySchema keySchema;
    private final double readLimit;
    private final double writeLimit;
    private final int itemLimit;
    private final int totalSegments;
    private transient SystemProperties com$audienceproject$spark$dynamodb$connector$DynamoConnector$$properties;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public DynamoDB getDynamoDB(Option<String> region, Option<String> roleArn, Option<String> providerClassName) {
        return DynamoConnector.getDynamoDB$(this, region, roleArn, providerClassName);
    }

    @Override
    public Option<String> getDynamoDB$default$1() {
        return DynamoConnector.getDynamoDB$default$1$(this);
    }

    @Override
    public Option<String> getDynamoDB$default$2() {
        return DynamoConnector.getDynamoDB$default$2$(this);
    }

    @Override
    public Option<String> getDynamoDB$default$3() {
        return DynamoConnector.getDynamoDB$default$3$(this);
    }

    @Override
    public AmazonDynamoDBAsync getDynamoDBAsyncClient(Option<String> region, Option<String> roleArn, Option<String> providerClassName) {
        return DynamoConnector.getDynamoDBAsyncClient$(this, region, roleArn, providerClassName);
    }

    @Override
    public Option<String> getDynamoDBAsyncClient$default$1() {
        return DynamoConnector.getDynamoDBAsyncClient$default$1$(this);
    }

    @Override
    public Option<String> getDynamoDBAsyncClient$default$2() {
        return DynamoConnector.getDynamoDBAsyncClient$default$2$(this);
    }

    @Override
    public Option<String> getDynamoDBAsyncClient$default$3() {
        return DynamoConnector.getDynamoDBAsyncClient$default$3$(this);
    }

    @Override
    public boolean isEmpty() {
        return DynamoConnector.isEmpty$(this);
    }

    @Override
    public boolean nonEmpty() {
        return DynamoConnector.nonEmpty$(this);
    }

    private SystemProperties com$audienceproject$spark$dynamodb$connector$DynamoConnector$$properties$lzycompute() {
        TableConnector tableConnector = this;
        synchronized (tableConnector) {
            if (!this.bitmap$trans$0) {
                this.com$audienceproject$spark$dynamodb$connector$DynamoConnector$$properties = DynamoConnector.com$audienceproject$spark$dynamodb$connector$DynamoConnector$$properties$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.com$audienceproject$spark$dynamodb$connector$DynamoConnector$$properties;
    }

    @Override
    public SystemProperties com$audienceproject$spark$dynamodb$connector$DynamoConnector$$properties() {
        return !this.bitmap$trans$0 ? this.com$audienceproject$spark$dynamodb$connector$DynamoConnector$$properties$lzycompute() : this.com$audienceproject$spark$dynamodb$connector$DynamoConnector$$properties;
    }

    private boolean consistentRead() {
        return this.consistentRead;
    }

    private boolean filterPushdown() {
        return this.filterPushdown;
    }

    private Option<String> region() {
        return this.region;
    }

    private Option<String> roleArn() {
        return this.roleArn;
    }

    private Option<String> providerClassName() {
        return this.providerClassName;
    }

    @Override
    public boolean filterPushdownEnabled() {
        return this.filterPushdownEnabled;
    }

    @Override
    public KeySchema keySchema() {
        return this.keySchema;
    }

    @Override
    public double readLimit() {
        return this.readLimit;
    }

    @Override
    public double writeLimit() {
        return this.writeLimit;
    }

    @Override
    public int itemLimit() {
        return this.itemLimit;
    }

    @Override
    public int totalSegments() {
        return this.totalSegments;
    }

    @Override
    public ItemCollection<ScanOutcome> scan(int segmentNum, Seq<String> columns, Seq<Filter> filters) {
        BoxedUnit boxedUnit;
        ScanSpec scanSpec = new ScanSpec().withSegment(Predef$.MODULE$.int2Integer(segmentNum)).withTotalSegments(Predef$.MODULE$.int2Integer(this.totalSegments())).withMaxPageSize(this.itemLimit()).withReturnConsumedCapacity(ReturnConsumedCapacity.TOTAL).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.consistentRead()));
        if (columns.nonEmpty()) {
            ExpressionSpecBuilder xspec = new ExpressionSpecBuilder().addProjections((String[])columns.toArray(ClassTag$.MODULE$.apply(String.class)));
            Object object = filters.nonEmpty() && this.filterPushdown() ? xspec.withCondition(FilterPushdown$.MODULE$.apply(filters)) : BoxedUnit.UNIT;
            boxedUnit = scanSpec.withExpressionSpec(xspec.buildForScan());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.getDynamoDB(this.region(), this.roleArn(), this.providerClassName()).getTable(this.tableName).scan(scanSpec);
    }

    @Override
    public void putItems(ColumnSchema columnSchema, Seq<InternalRow> items, DynamoDB client, RateLimiter rateLimiter) {
        BatchWriteItemSpec batchWriteItemSpec = new BatchWriteItemSpec().withReturnConsumedCapacity(ReturnConsumedCapacity.TOTAL);
        batchWriteItemSpec.withTableWriteItems(new TableWriteItems[]{new TableWriteItems(this.tableName).withItemsToPut((Item[])((TraversableOnce)items.map((Function1 & Serializable & scala.Serializable)row -> {
            void var3_2;
            Item item;
            Left left;
            Tuple3 tuple3;
            Item item2 = new Item();
            Either<Tuple3<String, Object, DataType>, Tuple2<Tuple3<String, Object, DataType>, Tuple3<String, Object, DataType>>> either = columnSchema.keys();
            if (either instanceof Left && (tuple3 = (Tuple3)(left = (Left)either).value()) != null) {
                String hashKey = (String)tuple3._1();
                int hashKeyIndex = BoxesRunTime.unboxToInt((Object)tuple3._2());
                DataType hashKeyType = (DataType)tuple3._3();
                item = item2.withPrimaryKey(hashKey, JavaConverter$.MODULE$.convertRowValue((InternalRow)row, hashKeyIndex, hashKeyType));
            } else {
                Right right;
                Tuple2 tuple2;
                if (!(either instanceof Right) || (tuple2 = (Tuple2)(right = (Right)either).value()) == null) throw new MatchError(either);
                Tuple3 tuple32 = (Tuple3)tuple2._1();
                Tuple3 tuple33 = (Tuple3)tuple2._2();
                if (tuple32 == null) throw new MatchError(either);
                String hashKey = (String)tuple32._1();
                int hashKeyIndex = BoxesRunTime.unboxToInt((Object)tuple32._2());
                DataType hashKeyType = (DataType)tuple32._3();
                if (tuple33 == null) throw new MatchError(either);
                String rangeKey = (String)tuple33._1();
                int rangeKeyIndex = BoxesRunTime.unboxToInt((Object)tuple33._2());
                DataType rangeKeyType = (DataType)tuple33._3();
                Object hashKeyValue = JavaConverter$.MODULE$.convertRowValue((InternalRow)row, hashKeyIndex, hashKeyType);
                Object rangeKeyValue = JavaConverter$.MODULE$.convertRowValue((InternalRow)row, rangeKeyIndex, rangeKeyType);
                item = item2.withPrimaryKey(hashKey, hashKeyValue, rangeKey, rangeKeyValue);
            }
            columnSchema.attributes().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple3 tuple3 = x0$1;
                if (tuple3 == null) return BoxedUnit.UNIT;
                String name = (String)tuple3._1();
                int index = BoxesRunTime.unboxToInt((Object)tuple3._2());
                DataType dataType = (DataType)tuple3._3();
                if (row.isNullAt(index)) return BoxedUnit.UNIT;
                return item2.with(name, JavaConverter$.MODULE$.convertRowValue((InternalRow)row, index, dataType));
            });
            return var3_2;
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Item.class)))});
        BatchWriteItemOutcome response = client.batchWriteItem(batchWriteItemSpec);
        this.handleBatchWriteResponse(client, rateLimiter, response);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateItem(ColumnSchema columnSchema, InternalRow row, DynamoDB client, RateLimiter rateLimiter) {
        UpdateItemSpec updateItemSpec;
        Left left;
        Tuple3 tuple3;
        UpdateItemSpec updateItemSpec2 = new UpdateItemSpec().withReturnConsumedCapacity(ReturnConsumedCapacity.TOTAL);
        Either<Tuple3<String, Object, DataType>, Tuple2<Tuple3<String, Object, DataType>, Tuple3<String, Object, DataType>>> either = columnSchema.keys();
        if (either instanceof Left && (tuple3 = (Tuple3)(left = (Left)either).value()) != null) {
            String hashKey = (String)tuple3._1();
            int hashKeyIndex = BoxesRunTime.unboxToInt((Object)tuple3._2());
            DataType hashKeyType = (DataType)tuple3._3();
            updateItemSpec = updateItemSpec2.withPrimaryKey(hashKey, JavaConverter$.MODULE$.convertRowValue(row, hashKeyIndex, hashKeyType));
        } else {
            Right right;
            Tuple2 tuple2;
            if (!(either instanceof Right) || (tuple2 = (Tuple2)(right = (Right)either).value()) == null) throw new MatchError(either);
            Tuple3 tuple32 = (Tuple3)tuple2._1();
            Tuple3 tuple33 = (Tuple3)tuple2._2();
            if (tuple32 == null) throw new MatchError(either);
            String hashKey = (String)tuple32._1();
            int hashKeyIndex = BoxesRunTime.unboxToInt((Object)tuple32._2());
            DataType hashKeyType = (DataType)tuple32._3();
            if (tuple33 == null) throw new MatchError(either);
            String rangeKey = (String)tuple33._1();
            int rangeKeyIndex = BoxesRunTime.unboxToInt((Object)tuple33._2());
            DataType rangeKeyType = (DataType)tuple33._3();
            Object hashKeyValue = JavaConverter$.MODULE$.convertRowValue(row, hashKeyIndex, hashKeyType);
            Object rangeKeyValue = JavaConverter$.MODULE$.convertRowValue(row, rangeKeyIndex, rangeKeyType);
            updateItemSpec = updateItemSpec2.withPrimaryKey(hashKey, hashKeyValue, rangeKey, rangeKeyValue);
        }
        Seq attributeUpdates = (Seq)columnSchema.attributes().collect((PartialFunction)new scala.Serializable(null, row){
            public static final long serialVersionUID = 0L;
            private final InternalRow row$2;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple3<String, Object, DataType>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    String name = (String)A1._1();
                    int index = BoxesRunTime.unboxToInt((Object)A1._2());
                    DataType dataType = (DataType)A1._3();
                    if (!this.row$2.isNullAt(index)) {
                        object = new AttributeUpdate(name).put(JavaConverter$.MODULE$.convertRowValue(this.row$2, index, dataType));
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple3<String, Object, DataType> x1) {
                int index;
                Tuple3<String, Object, DataType> tuple3 = x1;
                boolean bl = tuple3 != null && !this.row$2.isNullAt(index = BoxesRunTime.unboxToInt((Object)tuple3._2()));
                return bl;
            }
            {
                this.row$2 = row$2;
            }
        }, Seq$.MODULE$.canBuildFrom());
        updateItemSpec2.withAttributeUpdate((AttributeUpdate[])attributeUpdates.toArray(ClassTag$.MODULE$.apply(AttributeUpdate.class)));
        UpdateItemOutcome response = client.getTable(this.tableName).updateItem(updateItemSpec2);
        Option$.MODULE$.apply((Object)response.getUpdateItemResult().getConsumedCapacity()).foreach((Function1 & Serializable & scala.Serializable)cap -> {
            rateLimiter.acquire(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper((int)Predef$.MODULE$.Double2double(cap.getCapacityUnits())), 1));
            return BoxedUnit.UNIT;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void deleteItems(ColumnSchema columnSchema, Seq<InternalRow> items, DynamoDB client, RateLimiter rateLimiter) {
        TableWriteItems tableWriteItems;
        Left left;
        Tuple3 tuple3;
        BatchWriteItemSpec batchWriteItemSpec = new BatchWriteItemSpec().withReturnConsumedCapacity(ReturnConsumedCapacity.TOTAL);
        TableWriteItems tableWriteItems2 = new TableWriteItems(this.tableName);
        Either<Tuple3<String, Object, DataType>, Tuple2<Tuple3<String, Object, DataType>, Tuple3<String, Object, DataType>>> either = columnSchema.keys();
        if (either instanceof Left && (tuple3 = (Tuple3)(left = (Left)either).value()) != null) {
            String hashKey = (String)tuple3._1();
            int hashKeyIndex = BoxesRunTime.unboxToInt((Object)tuple3._2());
            DataType hashKeyType = (DataType)tuple3._3();
            Seq hashKeys = (Seq)items.map((Function1 & Serializable & scala.Serializable)row -> JavaConverter$.MODULE$.convertRowValue((InternalRow)row, hashKeyIndex, hashKeyType), Seq$.MODULE$.canBuildFrom());
            tableWriteItems = tableWriteItems2.withHashOnlyKeysToDelete(hashKey, (Object[])hashKeys.toArray(ClassTag$.MODULE$.AnyRef()));
        } else {
            Right right;
            Tuple2 tuple2;
            if (!(either instanceof Right) || (tuple2 = (Tuple2)(right = (Right)either).value()) == null) throw new MatchError(either);
            Tuple3 tuple32 = (Tuple3)tuple2._1();
            Tuple3 tuple33 = (Tuple3)tuple2._2();
            if (tuple32 == null) throw new MatchError(either);
            String hashKey = (String)tuple32._1();
            int hashKeyIndex = BoxesRunTime.unboxToInt((Object)tuple32._2());
            DataType hashKeyType = (DataType)tuple32._3();
            if (tuple33 == null) throw new MatchError(either);
            String rangeKey = (String)tuple33._1();
            int rangeKeyIndex = BoxesRunTime.unboxToInt((Object)tuple33._2());
            DataType rangeKeyType = (DataType)tuple33._3();
            Seq alternatingHashAndRangeKeys = (Seq)items.flatMap((Function1 & Serializable & scala.Serializable)row -> {
                Object hashKeyValue = JavaConverter$.MODULE$.convertRowValue((InternalRow)row, hashKeyIndex, hashKeyType);
                Object rangeKeyValue = JavaConverter$.MODULE$.convertRowValue((InternalRow)row, rangeKeyIndex, rangeKeyType);
                return (Seq)new .colon.colon(hashKeyValue, (List)new .colon.colon(rangeKeyValue, (List)Nil$.MODULE$));
            }, Seq$.MODULE$.canBuildFrom());
            tableWriteItems = tableWriteItems2.withHashAndRangeKeysToDelete(hashKey, rangeKey, (Object[])alternatingHashAndRangeKeys.toArray(ClassTag$.MODULE$.AnyRef()));
        }
        TableWriteItems tableWriteItemsWithItems = tableWriteItems;
        batchWriteItemSpec.withTableWriteItems(new TableWriteItems[]{tableWriteItemsWithItems});
        BatchWriteItemOutcome response = client.batchWriteItem(batchWriteItemSpec);
        this.handleBatchWriteResponse(client, rateLimiter, response);
    }

    private void handleBatchWriteResponse(DynamoDB client, RateLimiter rateLimiter, BatchWriteItemOutcome response) {
        while (true) {
            BatchWriteItemOutcome newResponse;
            if (response.getBatchWriteItemResult().getConsumedCapacity() != null) {
                ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(response.getBatchWriteItemResult().getConsumedCapacity()).asScala()).map((Function1 & Serializable & scala.Serializable)cap -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)cap.getTableName()), (Object)BoxesRunTime.boxToInteger((int)((int)Predef$.MODULE$.Double2double(cap.getCapacityUnits())))), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()).get((Object)this.tableName).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)units -> rateLimiter.acquire(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(units), 1)));
            }
            if (response.getUnprocessedItems() == null || response.getUnprocessedItems().isEmpty()) break;
            response = newResponse = client.batchWriteItemUnprocessed(response.getUnprocessedItems());
        }
    }

    public static final /* synthetic */ int $anonfun$x$6$4(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$x$6$7(Long x$2) {
        return Predef$.MODULE$.Long2long(x$2) > 0L;
    }

    public static final /* synthetic */ boolean $anonfun$x$6$11(Long x$4) {
        return Predef$.MODULE$.Long2long(x$4) > 0L;
    }

    public TableConnector(String tableName, int parallelism, Map<String, String> parameters) {
        this.tableName = tableName;
        this.parallelism = parallelism;
        DynamoConnector.$init$(this);
        this.consistentRead = new StringOps(Predef$.MODULE$.augmentString((String)parameters.getOrElse((Object)"stronglyconsistentreads", (Function0 & Serializable & scala.Serializable)() -> "false"))).toBoolean();
        this.filterPushdown = new StringOps(Predef$.MODULE$.augmentString((String)parameters.getOrElse((Object)"filterpushdown", (Function0 & Serializable & scala.Serializable)() -> "true"))).toBoolean();
        this.region = parameters.get((Object)"region");
        this.roleArn = parameters.get((Object)"rolearn");
        this.providerClassName = parameters.get((Object)"providerclassname");
        this.filterPushdownEnabled = this.filterPushdown();
        Table table = this.getDynamoDB(this.region(), this.roleArn(), this.providerClassName()).getTable(tableName);
        TableDescription desc = table.describe();
        KeySchema keySchema = KeySchema$.MODULE$.fromDescription((Seq<KeySchemaElement>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(desc.getKeySchema()).asScala()));
        int bytesPerRCU = new StringOps(Predef$.MODULE$.augmentString((String)parameters.getOrElse((Object)"bytesperrcu", (Function0 & Serializable & scala.Serializable)() -> "4000"))).toInt();
        int maxPartitionBytes = new StringOps(Predef$.MODULE$.augmentString((String)parameters.getOrElse((Object)"maxpartitionbytes", (Function0 & Serializable & scala.Serializable)() -> "128000000"))).toInt();
        double targetCapacity = new StringOps(Predef$.MODULE$.augmentString((String)parameters.getOrElse((Object)"targetcapacity", (Function0 & Serializable & scala.Serializable)() -> "1"))).toDouble();
        int readFactor = this.consistentRead() ? 1 : 2;
        Long tableSize = desc.getTableSizeBytes();
        Long itemCount = desc.getItemCount();
        int numPartitions = BoxesRunTime.unboxToInt((Object)parameters.get((Object)"readpartitions").map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)TableConnector.$anonfun$x$6$4(x$1))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
            void var3_3;
            int sizeBased = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper((int)(Predef$.MODULE$.Long2long(tableSize) / (long)maxPartitionBytes)), 1);
            int remainder = sizeBased % $this.parallelism;
            return remainder > 0 ? sizeBased + ($this.parallelism - remainder) : var3_3;
        }));
        long readThroughput = new StringOps(Predef$.MODULE$.augmentString((String)parameters.getOrElse((Object)"throughput", (Function0 & Serializable & scala.Serializable)() -> (String)Option$.MODULE$.apply((Object)desc.getProvisionedThroughput().getReadCapacityUnits()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TableConnector.$anonfun$x$6$7(x$2))).map((Function1 & Serializable & scala.Serializable)x$3 -> ((Object)BoxesRunTime.boxToLong((long)x$3)).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "100")))).toLong();
        long writeThroughput = new StringOps(Predef$.MODULE$.augmentString((String)parameters.getOrElse((Object)"throughput", (Function0 & Serializable & scala.Serializable)() -> (String)Option$.MODULE$.apply((Object)desc.getProvisionedThroughput().getWriteCapacityUnits()).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TableConnector.$anonfun$x$6$11(x$4))).map((Function1 & Serializable & scala.Serializable)x$5 -> ((Object)BoxesRunTime.boxToLong((long)x$5)).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "100")))).toLong();
        double avgItemSize = (double)Predef$.MODULE$.Long2long(tableSize) / (double)Predef$.MODULE$.Long2long(itemCount);
        double readCapacity = (double)readThroughput * targetCapacity;
        double writeCapacity = (double)writeThroughput * targetCapacity;
        double readLimit = readCapacity / (double)parallelism;
        int itemLimit = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper((int)((double)bytesPerRCU / avgItemSize * readLimit) * readFactor), 1);
        double writeLimit = writeCapacity / (double)parallelism;
        Tuple5 tuple5 = new Tuple5((Object)keySchema, (Object)BoxesRunTime.boxToDouble((double)readLimit), (Object)BoxesRunTime.boxToDouble((double)writeLimit), (Object)BoxesRunTime.boxToInteger((int)itemLimit), (Object)BoxesRunTime.boxToInteger((int)numPartitions));
        if (tuple5 == null) {
            throw new MatchError((Object)tuple5);
        }
        KeySchema keySchema2 = (KeySchema)tuple5._1();
        double readLimit2 = BoxesRunTime.unboxToDouble((Object)tuple5._2());
        double writeLimit2 = BoxesRunTime.unboxToDouble((Object)tuple5._3());
        int itemLimit2 = BoxesRunTime.unboxToInt((Object)tuple5._4());
        int totalSegments = BoxesRunTime.unboxToInt((Object)tuple5._5());
        Tuple5 tuple52 = new Tuple5((Object)keySchema2, (Object)BoxesRunTime.boxToDouble((double)readLimit2), (Object)BoxesRunTime.boxToDouble((double)writeLimit2), (Object)BoxesRunTime.boxToInteger((int)itemLimit2), (Object)BoxesRunTime.boxToInteger((int)totalSegments));
        this.x$6 = tuple52;
        this.keySchema = (KeySchema)this.x$6._1();
        this.readLimit = BoxesRunTime.unboxToDouble((Object)this.x$6._2());
        this.writeLimit = BoxesRunTime.unboxToDouble((Object)this.x$6._3());
        this.itemLimit = BoxesRunTime.unboxToInt((Object)this.x$6._4());
        this.totalSegments = BoxesRunTime.unboxToInt((Object)this.x$6._5());
    }
}

