/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.model;

import com.aventstack.extentreports.ExtentReports;
import com.aventstack.extentreports.RunResult;
import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.gherkin.model.IGherkinFormatterModel;
import com.aventstack.extentreports.model.AbstractStructure;
import com.aventstack.extentreports.model.Attribute;
import com.aventstack.extentreports.model.BasicMongoReportElement;
import com.aventstack.extentreports.model.ExceptionInfo;
import com.aventstack.extentreports.model.Log;
import com.aventstack.extentreports.model.ScreenCapture;
import com.google.gson.annotations.Expose;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import org.bson.types.ObjectId;

public class Test
implements Serializable,
RunResult,
BasicMongoReportElement {
    private static final long serialVersionUID = -8681630689550647312L;
    private static final AtomicInteger atomicInt = new AtomicInteger(0);
    private transient ExtentReports extent;
    private int level = 0;
    private transient int id = atomicInt.incrementAndGet();
    private ObjectId objectId;
    private transient Test parent;
    private Status status = Status.PASS;
    private AbstractStructure<Test> nodeContext;
    private AbstractStructure<Log> logContext;
    private AbstractStructure<Attribute> categoryContext;
    private AbstractStructure<Attribute> authorContext;
    private AbstractStructure<Attribute> deviceContext;
    private Date startTime = Calendar.getInstance().getTime();
    private Date endTime = Calendar.getInstance().getTime();
    private transient Class<? extends IGherkinFormatterModel> bddType;
    @Expose
    private String bddTypeName;
    private transient AbstractStructure<ScreenCapture> screenCaptureContext;
    private transient AbstractStructure<ExceptionInfo> exceptionInfoContext;
    private String name;
    private String description;
    private boolean usesManualConfiguration = false;

    public ExtentReports getExtent() {
        return this.extent;
    }

    public void setExtent(ExtentReports extent) {
        this.extent = extent;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Test getParent() {
        return this.parent;
    }

    public void setParent(Test parent) {
        this.parent = parent;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public AbstractStructure<Test> getNodeContext() {
        if (this.nodeContext == null) {
            this.nodeContext = new AbstractStructure();
        }
        return this.nodeContext;
    }

    public void setNodeContext(AbstractStructure<Test> node) {
        this.nodeContext = node;
    }

    public AbstractStructure<Log> getLogContext() {
        if (this.logContext == null) {
            this.logContext = new AbstractStructure();
        }
        return this.logContext;
    }

    public void setLogContext(AbstractStructure<Log> log) {
        this.logContext = log;
    }

    public AbstractStructure<Attribute> getCategoryContext() {
        if (this.categoryContext == null) {
            this.categoryContext = new AbstractStructure();
        }
        return this.categoryContext;
    }

    public void setCategoryContext(AbstractStructure<Attribute> category) {
        this.categoryContext = category;
    }

    public AbstractStructure<Attribute> getAuthorContext() {
        if (this.authorContext == null) {
            this.authorContext = new AbstractStructure();
        }
        return this.authorContext;
    }

    public void setAuthorContext(AbstractStructure<Attribute> author) {
        this.authorContext = author;
    }

    public AbstractStructure<Attribute> getDeviceContext() {
        if (this.deviceContext == null) {
            this.deviceContext = new AbstractStructure();
        }
        return this.deviceContext;
    }

    public void setDeviceContext(AbstractStructure<Attribute> device) {
        this.deviceContext = device;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Class<? extends IGherkinFormatterModel> getBddType() {
        return this.bddType;
    }

    public void setBddType(Class<? extends IGherkinFormatterModel> bddType) {
        this.bddType = bddType;
        this.bddTypeName = this.getBehaviorDrivenTypeName();
    }

    public AbstractStructure<ScreenCapture> getScreenCaptureContext() {
        if (this.screenCaptureContext == null) {
            this.screenCaptureContext = new AbstractStructure();
        }
        return this.screenCaptureContext;
    }

    public void setScreenCaptureContext(AbstractStructure<ScreenCapture> screenCapture) {
        this.screenCaptureContext = screenCapture;
    }

    public AbstractStructure<ExceptionInfo> getExceptionInfoContext() {
        if (this.exceptionInfoContext == null) {
            this.exceptionInfoContext = new AbstractStructure();
        }
        return this.exceptionInfoContext;
    }

    public void setExceptionInfoContext(AbstractStructure<ExceptionInfo> exception) {
        this.exceptionInfoContext = exception;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isUsesManualConfiguration() {
        return this.usesManualConfiguration;
    }

    public void setUsesManualConfiguration(boolean usesManualConfiguration) {
        this.usesManualConfiguration = usesManualConfiguration;
    }

    private synchronized void updateStatus(Status logStatus) {
        int testStatusIndex;
        int logStatusIndex = Status.getStatusHierarchy().indexOf(logStatus);
        this.status = logStatusIndex < (testStatusIndex = Status.getStatusHierarchy().indexOf(this.status)) ? logStatus : this.status;
    }

    public void end() {
        this.updateTestStatusRecursive(this);
        this.endChildrenRecursive(this);
        Status status = this.status = this.status == Status.INFO || this.status == Status.DEBUG ? Status.PASS : this.status;
        if (!this.usesManualConfiguration) {
            this.computeEndTimeFromChildren();
        }
    }

    private synchronized void updateTestStatusRecursive(Test test) {
        test.getLogContext().getAll().forEach(x -> this.updateStatus(x.getStatus()));
        if (!test.getNodeContext().isEmpty()) {
            test.getNodeContext().getAll().forEach(this::updateTestStatusRecursive);
        }
        if (test.bddType == null) {
            boolean hasNodeNotSkipped = test.getNodeContext().getAll().stream().anyMatch(x -> x.getStatus() != Status.SKIP);
            if (this.status == Status.SKIP && hasNodeNotSkipped) {
                this.status = Status.PASS;
                test.getNodeContext().getAll().stream().filter(x -> x.getStatus() != Status.SKIP).forEach(this::updateTestStatusRecursive);
            }
        }
    }

    private void endChildrenRecursive(Test test) {
        test.getNodeContext().getAll().forEach(Test::end);
    }

    public void computeEndTimeFromChildren() {
        if (!this.getNodeContext().isEmpty()) {
            this.setStartTime(this.getNodeContext().getFirst().getStartTime());
            this.setEndTime(this.getNodeContext().getLast().getEndTime());
        } else if (!this.getLogContext().isEmpty()) {
            Date lastLogEndTime = this.getLogContext().getLast().getTimestamp();
            this.setEndTime(lastLogEndTime);
        }
    }

    public String getBehaviorDrivenTypeName() {
        if (this.bddTypeName != null) {
            return this.bddTypeName;
        }
        try {
            Method method = this.bddType.getMethod("getGherkinName", new Class[0]);
            Object o = method.invoke(null, null);
            return o.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Boolean isBehaviorDrivenType() {
        if (this.getBddType() != null) {
            return true;
        }
        return false;
    }

    @Override
    public ObjectId getObjectId() {
        return this.objectId;
    }

    @Override
    public void setObjectId(ObjectId id) {
        this.objectId = id;
    }
}

