/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports;

import com.aventstack.extentreports.AnalysisStrategy;
import com.aventstack.extentreports.InvalidAnalysisStrategyException;
import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.gherkin.model.Scenario;
import com.aventstack.extentreports.model.AbstractStructure;
import com.aventstack.extentreports.model.Log;
import com.aventstack.extentreports.model.Test;
import java.util.List;

public class ReportStatusStats {
    private List<Test> testList;
    private AnalysisStrategy strategy = AnalysisStrategy.TEST;
    private int parentPass = 0;
    private int parentFail = 0;
    private int parentFatal = 0;
    private int parentError = 0;
    private int parentWarning = 0;
    private int parentSkip = 0;
    private int parentExceptions = 0;
    private int childPass = 0;
    private int childFail = 0;
    private int childFatal = 0;
    private int childError = 0;
    private int childWarning = 0;
    private int childSkip = 0;
    private int childInfo = 0;
    private int childDebug = 0;
    private int childExceptions = 0;
    private int grandChildPass = 0;
    private int grandChildFail = 0;
    private int grandChildFatal = 0;
    private int grandChildError = 0;
    private int grandChildWarning = 0;
    private int grandChildSkip = 0;
    private int grandChildInfo = 0;
    private int grandChildDebug = 0;
    private int grandChildExceptions = 0;
    private int eventsPass = 0;
    private int eventsFail = 0;
    private int eventsFatal = 0;
    private int eventsError = 0;
    private int eventsWarning = 0;
    private int eventsSkip = 0;
    private int eventsInfo = 0;
    private int eventsDebug = 0;
    private int eventsExceptions = 0;

    public ReportStatusStats(AnalysisStrategy strategy) {
        this.strategy = strategy;
    }

    public void refresh(List<Test> testList) {
        this.reset();
        this.testList = testList;
        this.refreshStats();
    }

    private void reset() {
        this.parentPass = 0;
        this.parentFail = 0;
        this.parentFatal = 0;
        this.parentError = 0;
        this.parentWarning = 0;
        this.parentSkip = 0;
        this.parentExceptions = 0;
        this.childPass = 0;
        this.childFail = 0;
        this.childFatal = 0;
        this.childError = 0;
        this.childWarning = 0;
        this.childSkip = 0;
        this.childInfo = 0;
        this.childExceptions = 0;
        this.grandChildPass = 0;
        this.grandChildFail = 0;
        this.grandChildFatal = 0;
        this.grandChildError = 0;
        this.grandChildWarning = 0;
        this.grandChildSkip = 0;
        this.grandChildInfo = 0;
        this.grandChildExceptions = 0;
        this.eventsPass = 0;
        this.eventsFail = 0;
        this.eventsFatal = 0;
        this.eventsError = 0;
        this.eventsWarning = 0;
        this.eventsSkip = 0;
        this.eventsInfo = 0;
        this.eventsDebug = 0;
        this.eventsExceptions = 0;
    }

    public int getParentCount() {
        return this.getParentCountPass() + this.getParentCountFail() + this.getParentCountFatal() + this.getParentCountError() + this.getParentCountWarning() + this.getParentCountSkip();
    }

    public int getParentCountPass() {
        return this.parentPass;
    }

    public int getParentCountFail() {
        return this.parentFail;
    }

    public int getParentCountFatal() {
        return this.parentFatal;
    }

    public int getParentCountError() {
        return this.parentError;
    }

    public int getParentCountWarning() {
        return this.parentWarning;
    }

    public int getParentCountSkip() {
        return this.parentSkip;
    }

    public int getParentCountExceptions() {
        return this.parentExceptions;
    }

    public float getParentPercentagePass() {
        float p = this.getParentCount() > 0 ? (float)this.getParentCountPass() / (float)this.getParentCount() : 0.0f;
        return p * 100.0f;
    }

    public float getParentPercentageFail() {
        float p = this.getParentCount() > 0 ? ((float)this.getParentCountFail() + (float)this.getParentCountFatal()) / (float)this.getParentCount() : 0.0f;
        return p * 100.0f;
    }

    public float getParentPercentageOthers() {
        float p = this.getParentCount() > 0 ? ((float)this.getParentCountWarning() + (float)this.getParentCountError()) / (float)this.getParentCount() : 0.0f;
        return p * 100.0f;
    }

    public float getParentPercentageSkip() {
        float p = this.getParentCount() > 0 ? (float)this.getParentCountSkip() / (float)this.getParentCount() : 0.0f;
        return p * 100.0f;
    }

    public int getChildCount() {
        return this.getChildCountPass() + this.getChildCountFail() + this.getChildCountFatal() + this.getChildCountError() + this.getChildCountWarning() + this.getChildCountSkip() + this.getChildCountInfo();
    }

    public int getChildCountPass() {
        return this.childPass;
    }

    public int getChildCountFail() {
        return this.childFail;
    }

    public int getChildCountFatal() {
        return this.childFatal;
    }

    public int getChildCountError() {
        return this.childError;
    }

    public int getChildCountWarning() {
        return this.childWarning;
    }

    public int getChildCountSkip() {
        return this.childSkip;
    }

    public int getChildCountInfo() {
        return this.childInfo;
    }

    public int getChildCountDebug() {
        return this.childDebug;
    }

    public int getChildCountExceptions() {
        return this.childExceptions;
    }

    public float getChildPercentagePass() {
        float p = this.getChildCount() > 0 ? (float)this.getChildCountPass() / (float)this.getChildCount() : 0.0f;
        return p * 100.0f;
    }

    public float getChildPercentageFail() {
        float p = this.getChildCount() > 0 ? ((float)this.getChildCountFail() + (float)this.getChildCountFatal()) / (float)this.getChildCount() : 0.0f;
        return p * 100.0f;
    }

    public float getChildPercentageOthers() {
        float p = this.getChildCount() > 0 ? ((float)this.getChildCountWarning() + (float)this.getChildCountError() + (float)this.getChildCountSkip() + (float)this.getChildCountInfo()) / (float)this.getChildCount() : 0.0f;
        return p * 100.0f;
    }

    public float getChildPercentageSkip() {
        float p = this.getChildCount() > 0 ? (float)this.getChildCountSkip() / (float)this.getChildCount() : 0.0f;
        return p * 100.0f;
    }

    public int getGrandChildCount() {
        return this.getGrandChildCountPass() + this.getGrandChildCountFail() + this.getGrandChildCountFatal() + this.getGrandChildCountError() + this.getGrandChildCountWarning() + this.getGrandChildCountSkip() + this.getGrandChildCountInfo();
    }

    public int getGrandChildCountPass() {
        return this.grandChildPass;
    }

    public int getGrandChildCountFail() {
        return this.grandChildFail;
    }

    public int getGrandChildCountFatal() {
        return this.grandChildFatal;
    }

    public int getGrandChildCountError() {
        return this.grandChildError;
    }

    public int getGrandChildCountWarning() {
        return this.grandChildWarning;
    }

    public int getGrandChildCountSkip() {
        return this.grandChildSkip;
    }

    public int getGrandChildCountInfo() {
        return this.grandChildInfo;
    }

    public int getGrandChildCountDebug() {
        return this.grandChildDebug;
    }

    public int getGrandChildCountExceptions() {
        return this.grandChildExceptions;
    }

    public float getGrandChildPercentagePass() {
        float p = this.getGrandChildCount() > 0 ? (float)this.getGrandChildCountPass() / (float)this.getGrandChildCount() : 0.0f;
        return p * 100.0f;
    }

    public float getGrandChildPercentageFail() {
        float p = this.getGrandChildCount() > 0 ? ((float)this.getGrandChildCountFail() + (float)this.getGrandChildCountFatal()) / (float)this.getGrandChildCount() : 0.0f;
        return p * 100.0f;
    }

    public float getGrandChildPercentageOthers() {
        float p = this.getGrandChildCount() > 0 ? ((float)this.getGrandChildCountWarning() + (float)this.getGrandChildCountError() + (float)this.getGrandChildCountSkip() + (float)this.getGrandChildCountInfo()) / (float)this.getGrandChildCount() : 0.0f;
        return p * 100.0f;
    }

    public float getGrandChildPercentageSkip() {
        float p = this.getGrandChildCount() > 0 ? (float)this.getGrandChildCountSkip() / (float)this.getGrandChildCount() : 0.0f;
        return p * 100.0f;
    }

    public int getEventsCount() {
        return this.getEventsCountPass() + this.getEventsCountFail() + this.getEventsCountFatal() + this.getEventsCountError() + this.getEventsCountWarning() + this.getEventsCountSkip() + this.getEventsCountInfo();
    }

    public int getEventsCountPass() {
        return this.eventsPass;
    }

    public int getEventsCountFail() {
        return this.eventsFail;
    }

    public int getEventsCountFatal() {
        return this.eventsFatal;
    }

    public int getEventsCountError() {
        return this.eventsError;
    }

    public int getEventsCountWarning() {
        return this.eventsWarning;
    }

    public int getEventsCountSkip() {
        return this.eventsSkip;
    }

    public int getEventsCountInfo() {
        return this.eventsInfo;
    }

    public int getEventsCountDebug() {
        return this.eventsDebug;
    }

    public int getEventsCountExceptions() {
        return this.eventsExceptions;
    }

    public float getEventsPercentagePass() {
        float p = this.getEventsCount() > 0 ? (float)this.getEventsCountPass() / (float)this.getEventsCount() : 0.0f;
        return p * 100.0f;
    }

    public float getEventsPercentageFail() {
        float p = this.getEventsCount() > 0 ? ((float)this.getEventsCountFail() + (float)this.getEventsCountFatal()) / (float)this.getEventsCount() : 0.0f;
        return p * 100.0f;
    }

    public float getEventsPercentageOthers() {
        float p = this.getEventsCount() > 0 ? ((float)this.getEventsCountWarning() + (float)this.getEventsCountError() + (float)this.getEventsCountSkip() + (float)this.getEventsCountInfo()) / (float)this.getEventsCount() : 0.0f;
        return p * 100.0f;
    }

    public float getEventsPercentageSkip() {
        float p = this.getEventsCount() > 0 ? (float)this.getEventsCountSkip() / (float)this.getEventsCount() : 0.0f;
        return p * 100.0f;
    }

    private void refreshStats() {
        this.testList.forEach(this::addTestForStatusStatsUpdate);
    }

    private void addTestForStatusStatsUpdate(Test test) {
        this.updateEventsCount(test);
        if (test.getBddType() != null || !test.getNodeContext().isEmpty() && test.getNodeContext().get(0).getBddType() != null) {
            this.updateGroupCountsBDD(test);
            return;
        }
        if (this.strategy == AnalysisStrategy.TEST || this.strategy == AnalysisStrategy.CLASS) {
            this.updateGroupCountsTestStrategy(test);
            return;
        }
        if (this.strategy == AnalysisStrategy.SUITE) {
            this.updateGroupCountsSuiteStrategy(test);
            return;
        }
        throw new InvalidAnalysisStrategyException("No such strategy found: " + (Object)((Object)this.strategy));
    }

    private synchronized void updateEventsCount(Test test) {
        test.getLogContext().getAll().stream().map(Log::getStatus).forEach(this::incrementEvent);
        AbstractStructure.TIterator iter = test.getNodeContext().getIterator();
        while (iter.hasNext()) {
            Test node = (Test)iter.next();
            this.updateEventsCount(node);
        }
    }

    private void updateGroupCountsSuiteStrategy(Test test) {
        this.incrementItemCountByStatus(ItemLevel.PARENT, test.getStatus());
        if (!test.getNodeContext().isEmpty()) {
            for (Test x : test.getNodeContext().getAll()) {
                this.incrementItemCountByStatus(ItemLevel.CHILD, x.getStatus());
                if (x.getNodeContext().isEmpty()) continue;
                x.getNodeContext().getAll().forEach(n -> this.incrementItemCountByStatus(ItemLevel.GRANDCHILD, n.getStatus()));
            }
        }
    }

    private void updateGroupCountsBDD(Test test) {
        this.incrementItemCountByStatus(ItemLevel.PARENT, test.getStatus());
        if (!test.getNodeContext().isEmpty()) {
            for (Test x : test.getNodeContext().getAll()) {
                if (x.getBddType() == Scenario.class) {
                    this.incrementItemCountByStatus(ItemLevel.CHILD, x.getStatus());
                }
                if (x.getNodeContext().isEmpty()) continue;
                for (Test n : x.getNodeContext().getAll()) {
                    if (n.getBddType() == Scenario.class) {
                        this.incrementItemCountByStatus(ItemLevel.CHILD, n.getStatus());
                        n.getNodeContext().getAll().forEach(z -> this.incrementItemCountByStatus(ItemLevel.GRANDCHILD, z.getStatus()));
                        continue;
                    }
                    this.incrementItemCountByStatus(ItemLevel.GRANDCHILD, n.getStatus());
                }
            }
        }
    }

    private void updateGroupCountsTestStrategy(Test test) {
        this.incrementItemCountByStatus(ItemLevel.PARENT, test.getStatus());
        if (!test.getNodeContext().isEmpty()) {
            this.updateGroupCountsTestStrategyChildren(test);
        }
    }

    private void updateGroupCountsTestStrategyChildren(Test test) {
        test.getNodeContext().getAll().forEach(x -> {
            if (x.getNodeContext().isEmpty()) {
                this.incrementItemCountByStatus(ItemLevel.CHILD, x.getStatus());
            } else {
                this.updateGroupCountsTestStrategyChildren((Test)x);
            }
        });
    }

    private void incrementItemCountByStatus(ItemLevel item, Status status) {
        switch (item) {
            case PARENT: {
                this.incrementParent(status);
                break;
            }
            case CHILD: {
                this.incrementChild(status);
                break;
            }
            case GRANDCHILD: {
                this.incrementGrandChild(status);
                break;
            }
        }
    }

    private void incrementParent(Status status) {
        switch (status) {
            case PASS: {
                ++this.parentPass;
                return;
            }
            case FAIL: {
                ++this.parentFail;
                break;
            }
            case FATAL: {
                ++this.parentFatal;
                break;
            }
            case ERROR: {
                ++this.parentError;
                break;
            }
            case WARNING: {
                ++this.parentWarning;
                break;
            }
            case SKIP: {
                ++this.parentSkip;
                break;
            }
        }
        ++this.parentExceptions;
    }

    private void incrementChild(Status status) {
        switch (status) {
            case PASS: {
                ++this.childPass;
                break;
            }
            case FAIL: {
                ++this.childFail;
                break;
            }
            case FATAL: {
                ++this.childFatal;
                break;
            }
            case ERROR: {
                ++this.childError;
                break;
            }
            case WARNING: {
                ++this.childWarning;
                break;
            }
            case SKIP: {
                ++this.childSkip;
                break;
            }
            case INFO: {
                ++this.childInfo;
                break;
            }
            case DEBUG: {
                ++this.childDebug;
                break;
            }
        }
        if (status != Status.PASS && status != Status.INFO) {
            ++this.childExceptions;
        }
    }

    private void incrementGrandChild(Status status) {
        switch (status) {
            case PASS: {
                ++this.grandChildPass;
                break;
            }
            case FAIL: {
                ++this.grandChildFail;
                break;
            }
            case FATAL: {
                ++this.grandChildFatal;
                break;
            }
            case ERROR: {
                ++this.grandChildError;
                break;
            }
            case WARNING: {
                ++this.grandChildWarning;
                break;
            }
            case SKIP: {
                ++this.grandChildSkip;
                break;
            }
            case INFO: {
                ++this.grandChildInfo;
                break;
            }
            case DEBUG: {
                ++this.grandChildDebug;
                break;
            }
        }
        if (status != Status.PASS && status != Status.INFO) {
            ++this.grandChildExceptions;
        }
    }

    private void incrementEvent(Status status) {
        switch (status) {
            case PASS: {
                ++this.eventsPass;
                break;
            }
            case FAIL: {
                ++this.eventsFail;
                break;
            }
            case FATAL: {
                ++this.eventsFatal;
                break;
            }
            case ERROR: {
                ++this.eventsError;
                break;
            }
            case WARNING: {
                ++this.eventsWarning;
                break;
            }
            case SKIP: {
                ++this.eventsSkip;
                break;
            }
            case INFO: {
                ++this.eventsInfo;
                break;
            }
            case DEBUG: {
                ++this.eventsDebug;
                break;
            }
        }
    }

    static enum ItemLevel {
        PARENT,
        CHILD,
        GRANDCHILD;

    }
}

