/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.reporter;

import com.aventstack.extentreports.configuration.ConfigurationBuilder;
import com.aventstack.extentreports.configuration.ConfigurationStore;
import com.aventstack.extentreports.reporter.AbstractReporter;
import com.aventstack.extentreports.reporter.configuration.BasicConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ConfigurableReporter
extends AbstractReporter {
    private static final Logger logger = Logger.getLogger(ConfigurableReporter.class.getName());
    private BasicConfiguration basicConfiguration;

    public void loadXMLConfig(String filePath, Boolean silent) {
        this.loadXMLConfig(new File(filePath), silent);
    }

    public void loadXMLConfig(String filePath) {
        this.loadXMLConfig(filePath, (Boolean)false);
    }

    public void loadXMLConfig(File file) {
        this.loadXMLConfig(file, (Boolean)false);
    }

    public void loadXMLConfig(File file, Boolean silent) {
        ConfigurationBuilder builder = new ConfigurationBuilder(file, silent);
        ConfigurationStore store = builder.getConfigurationStore();
        this.basicConfiguration.getConfigurationStore().extendConfig(store);
    }

    public void loadConfig(Properties properties) {
        properties.entrySet().forEach(o -> {
            if (o.getKey() != null) {
                this.basicConfiguration.getConfigurationStore().storeConfig(o.getKey().toString(), o.getValue());
            }
        });
    }

    public void loadConfig(InputStream stream) {
        Properties properties = new Properties();
        try {
            properties.load(stream);
            this.loadConfig(properties);
        }
        catch (FileNotFoundException e) {
            logger.log(Level.SEVERE, "Default Properties file not found", e);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Unable to load properties file", e);
        }
    }

    public void loadConfig(String filePath) {
        try {
            FileInputStream is = new FileInputStream(filePath);
            this.loadConfig(is);
        }
        catch (FileNotFoundException e) {
            logger.log(Level.SEVERE, "Default Properties file not found", e);
        }
    }

    protected void loadUserConfig() {
        for (Map.Entry<String, Object> entry : this.getConfigurationStore().getStore().entrySet()) {
            this.getConfigurationStore().storeConfig(entry.getKey(), entry.getValue());
        }
    }

    protected void init(String[] configFilePath, BasicConfiguration userConfig) {
        this.basicConfiguration = userConfig;
        this.loadInternalReporterConfiguration(configFilePath);
    }

    protected void loadInternalReporterConfiguration(String[] configFilePath) {
        if (configFilePath == null || configFilePath.length == 0) {
            return;
        }
        ClassLoader loader = this.getClass().getClassLoader();
        Arrays.stream(configFilePath).map(x -> loader.getResourceAsStream((String)x)).filter(x -> x != null).findFirst().ifPresent(x -> this.loadConfig((InputStream)x));
    }

    public ConfigurationStore getConfigurationStore() {
        return this.basicConfiguration == null ? null : this.basicConfiguration.getConfigurationStore();
    }
}

