/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.templating;

import com.aventstack.extentreports.io.FileWriterBuffered;
import com.aventstack.extentreports.templating.TemplateConfig;
import freemarker.core.ParseException;
import freemarker.template.Configuration;
import freemarker.template.MalformedTemplateNameException;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateNotFoundException;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class FreemarkerTemplate {
    private TemplateConfig config = new TemplateConfig();
    private Configuration freemarkerConfiguration;

    public FreemarkerTemplate(Configuration freemarkerConfiguration) {
        this.freemarkerConfiguration = freemarkerConfiguration;
    }

    public FreemarkerTemplate(Class<?> clazz, String encoding) {
        this.freemarkerConfiguration = this.config.getFreemarkerConfig(clazz, encoding);
    }

    public FreemarkerTemplate(Class<?> clazz, String basePackagePath, String encoding) {
        this.freemarkerConfiguration = this.config.getFreemarkerConfig(clazz, basePackagePath, encoding);
    }

    public Template createTemplate(String templatePath) throws TemplateNotFoundException, MalformedTemplateNameException, ParseException, IOException {
        return this.freemarkerConfiguration.getTemplate(templatePath);
    }

    public String getSource(Template template, Map<String, Object> templateMap) throws TemplateException, IOException {
        String source = this.processTemplate(template, templateMap);
        return source;
    }

    public void writeTemplate(Template template, Map<String, Object> templateMap, File outputFile) throws TemplateException, IOException {
        String source = this.getSource(template, templateMap);
        FileWriterBuffered.getInstance().write(outputFile, source);
    }

    private String processTemplate(Template template, Map<String, Object> templateMap) throws TemplateException, IOException {
        StringWriter out = new StringWriter();
        template.process(templateMap, (Writer)out);
        String source = out.toString();
        out.close();
        return source;
    }
}

