/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.identity.implementation.converters;

import com.azure.communication.identity.implementation.models.CommunicationError;
import com.azure.communication.identity.implementation.models.CommunicationErrorResponseException;
import com.azure.communication.identity.models.IdentityError;
import com.azure.communication.identity.models.IdentityErrorResponseException;
import java.util.ArrayList;
import java.util.stream.Collectors;

public final class IdentityErrorConverter {
    public static IdentityErrorResponseException translateException(CommunicationErrorResponseException exception) {
        IdentityError error = null;
        if (exception.getValue() != null) {
            error = IdentityErrorConverter.convert(exception.getValue().getError());
        }
        return new IdentityErrorResponseException(exception.getMessage(), exception.getResponse(), error);
    }

    public static IdentityError convert(CommunicationError communicationError) {
        if (communicationError == null) {
            return null;
        }
        ArrayList<IdentityError> details = new ArrayList();
        if (communicationError.getDetails() != null) {
            details = communicationError.getDetails().stream().map(IdentityErrorConverter::convert).collect(Collectors.toList());
        }
        IdentityError identityError = new IdentityError(communicationError.getMessage(), communicationError.getCode(), communicationError.getTarget(), details);
        return identityError;
    }

    private IdentityErrorConverter() {
    }
}

