/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation;

import com.azure.core.amqp.AmqpTransaction;
import com.azure.core.amqp.exception.AmqpErrorCondition;
import com.azure.core.amqp.models.AmqpAddress;
import com.azure.core.amqp.models.AmqpAnnotatedMessage;
import com.azure.core.amqp.models.AmqpMessageBody;
import com.azure.core.amqp.models.AmqpMessageHeader;
import com.azure.core.amqp.models.AmqpMessageId;
import com.azure.core.amqp.models.AmqpMessageProperties;
import com.azure.core.amqp.models.DeliveryOutcome;
import com.azure.core.amqp.models.DeliveryState;
import com.azure.core.amqp.models.ModifiedDeliveryOutcome;
import com.azure.core.amqp.models.ReceivedDeliveryOutcome;
import com.azure.core.amqp.models.RejectedDeliveryOutcome;
import com.azure.core.amqp.models.TransactionalDeliveryOutcome;
import com.azure.core.util.logging.ClientLogger;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.amqp.messaging.Footer;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Modified;
import org.apache.qpid.proton.amqp.messaging.Outcome;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.amqp.messaging.Received;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.messaging.Released;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.amqp.transaction.Declared;
import org.apache.qpid.proton.amqp.transaction.TransactionalState;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.message.Message;

final class MessageUtils {
    private static final ClientLogger LOGGER = new ClientLogger(MessageUtils.class);
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    static Message toProtonJMessage(AmqpAnnotatedMessage message) {
        AmqpMessageHeader header;
        Objects.requireNonNull(message, "'message' to serialize cannot be null.");
        Message response = Proton.message();
        AmqpMessageBody body = message.getBody();
        switch (body.getBodyType()) {
            case DATA: {
                response.setBody((Section)new Data(new Binary(body.getFirstData())));
                break;
            }
            default: {
                throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("bodyType [" + (Object)((Object)body.getBodyType()) + "] is not supported yet."));
            }
        }
        AmqpMessageProperties properties = message.getProperties();
        response.setMessageId((Object)properties.getMessageId());
        response.setContentType(properties.getContentType());
        response.setCorrelationId((Object)properties.getCorrelationId());
        response.setSubject(properties.getSubject());
        AmqpAddress replyTo = properties.getReplyTo();
        response.setReplyTo(replyTo != null ? replyTo.toString() : null);
        response.setReplyToGroupId(properties.getReplyToGroupId());
        response.setGroupId(properties.getGroupId());
        response.setContentEncoding(properties.getContentEncoding());
        if (properties.getGroupSequence() != null) {
            response.setGroupSequence(properties.getGroupSequence().longValue());
        }
        AmqpAddress messageTo = properties.getTo();
        if (response.getProperties() == null) {
            response.setProperties(new Properties());
        }
        response.getProperties().setTo(messageTo != null ? messageTo.toString() : null);
        response.getProperties().setUserId(new Binary(properties.getUserId()));
        if (properties.getAbsoluteExpiryTime() != null) {
            response.getProperties().setAbsoluteExpiryTime(Date.from(properties.getAbsoluteExpiryTime().toInstant()));
        }
        if (properties.getCreationTime() != null) {
            response.getProperties().setCreationTime(Date.from(properties.getCreationTime().toInstant()));
        }
        if ((header = message.getHeader()).getTimeToLive() != null) {
            response.setTtl(header.getTimeToLive().toMillis());
        }
        if (header.getDeliveryCount() != null) {
            response.setDeliveryCount(header.getDeliveryCount().longValue());
        }
        if (header.getPriority() != null) {
            response.setPriority(header.getPriority().shortValue());
        }
        if (header.isDurable() != null) {
            response.setDurable(header.isDurable().booleanValue());
        }
        if (header.isFirstAcquirer() != null) {
            response.setFirstAcquirer(header.isFirstAcquirer().booleanValue());
        }
        if (header.getTimeToLive() != null) {
            response.setTtl(header.getTimeToLive().toMillis());
        }
        response.setFooter(new Footer(message.getFooter()));
        Map<Symbol, Object> messageAnnotations = MessageUtils.convert(message.getMessageAnnotations());
        response.setMessageAnnotations(new MessageAnnotations(messageAnnotations));
        Map<Symbol, Object> deliveryAnnotations = MessageUtils.convert(message.getDeliveryAnnotations());
        response.setDeliveryAnnotations(new DeliveryAnnotations(deliveryAnnotations));
        response.setApplicationProperties(new ApplicationProperties(message.getApplicationProperties()));
        return response;
    }

    static AmqpAnnotatedMessage toAmqpAnnotatedMessage(Message message) {
        MessageAnnotations messageAnnotations;
        Properties amqpProperties;
        Object messageId;
        Footer footer;
        byte[] bytes;
        Objects.requireNonNull(message, "'message' cannot be null");
        Section body = message.getBody();
        if (body != null) {
            if (body instanceof Data) {
                Binary messageData = ((Data)body).getValue();
                bytes = messageData.getArray();
            } else {
                LOGGER.warning("Message not of type Data. Actual: {}", new Object[]{body.getType()});
                bytes = EMPTY_BYTE_ARRAY;
            }
        } else {
            LOGGER.warning("Message does not have a body.");
            bytes = EMPTY_BYTE_ARRAY;
        }
        AmqpAnnotatedMessage response = new AmqpAnnotatedMessage(AmqpMessageBody.fromData(bytes));
        ApplicationProperties applicationProperties = message.getApplicationProperties();
        if (applicationProperties != null) {
            Map propertiesValue = applicationProperties.getValue();
            response.getApplicationProperties().putAll(propertiesValue);
        }
        AmqpMessageHeader responseHeader = response.getHeader();
        responseHeader.setTimeToLive(Duration.ofMillis(message.getTtl()));
        responseHeader.setDeliveryCount(message.getDeliveryCount());
        responseHeader.setPriority(message.getPriority());
        if (message.getHeader() != null) {
            responseHeader.setDurable(message.getHeader().getDurable());
            responseHeader.setFirstAcquirer(message.getHeader().getFirstAcquirer());
        }
        if ((footer = message.getFooter()) != null && footer.getValue() != null) {
            Map footerValue = footer.getValue();
            MessageUtils.setValues(footerValue, response.getFooter());
        }
        AmqpMessageProperties responseProperties = response.getProperties();
        responseProperties.setReplyToGroupId(message.getReplyToGroupId());
        String replyTo = message.getReplyTo();
        if (replyTo != null) {
            responseProperties.setReplyTo(new AmqpAddress(message.getReplyTo()));
        }
        if ((messageId = message.getMessageId()) != null) {
            responseProperties.setMessageId(new AmqpMessageId(messageId.toString()));
        }
        responseProperties.setContentType(message.getContentType());
        Object correlationId = message.getCorrelationId();
        if (correlationId != null) {
            responseProperties.setCorrelationId(new AmqpMessageId(correlationId.toString()));
        }
        if ((amqpProperties = message.getProperties()) != null) {
            String to = amqpProperties.getTo();
            if (to != null) {
                responseProperties.setTo(new AmqpAddress(amqpProperties.getTo()));
            }
            if (amqpProperties.getAbsoluteExpiryTime() != null) {
                responseProperties.setAbsoluteExpiryTime(amqpProperties.getAbsoluteExpiryTime().toInstant().atOffset(ZoneOffset.UTC));
            }
            if (amqpProperties.getCreationTime() != null) {
                responseProperties.setCreationTime(amqpProperties.getCreationTime().toInstant().atOffset(ZoneOffset.UTC));
            }
        }
        responseProperties.setSubject(message.getSubject());
        responseProperties.setGroupId(message.getGroupId());
        responseProperties.setContentEncoding(message.getContentEncoding());
        responseProperties.setGroupSequence(message.getGroupSequence());
        responseProperties.setUserId(message.getUserId());
        DeliveryAnnotations deliveryAnnotations = message.getDeliveryAnnotations();
        if (deliveryAnnotations != null) {
            MessageUtils.setValues(deliveryAnnotations.getValue(), response.getDeliveryAnnotations());
        }
        if ((messageAnnotations = message.getMessageAnnotations()) != null) {
            MessageUtils.setValues(messageAnnotations.getValue(), response.getMessageAnnotations());
        }
        return response;
    }

    static DeliveryOutcome toDeliveryOutcome(org.apache.qpid.proton.amqp.transport.DeliveryState deliveryState) {
        if (deliveryState == null) {
            return null;
        }
        switch (deliveryState.getType()) {
            case Accepted: {
                return new DeliveryOutcome(DeliveryState.ACCEPTED);
            }
            case Modified: {
                if (!(deliveryState instanceof Modified)) {
                    return new ModifiedDeliveryOutcome();
                }
                return MessageUtils.toDeliveryOutcome((Modified)deliveryState);
            }
            case Received: {
                if (!(deliveryState instanceof Received)) {
                    throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Received delivery state should have a Received state."));
                }
                Received received = (Received)deliveryState;
                if (received.getSectionNumber() == null || received.getSectionOffset() == null) {
                    throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Received delivery state does not have any offset or section number. " + received));
                }
                return new ReceivedDeliveryOutcome(received.getSectionNumber().intValue(), received.getSectionOffset().longValue());
            }
            case Rejected: {
                if (!(deliveryState instanceof Rejected)) {
                    return new DeliveryOutcome(DeliveryState.REJECTED);
                }
                return MessageUtils.toDeliveryOutcome((Rejected)deliveryState);
            }
            case Released: {
                return new DeliveryOutcome(DeliveryState.RELEASED);
            }
            case Declared: {
                if (!(deliveryState instanceof Declared)) {
                    throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Declared delivery type should have a declared outcome"));
                }
                return MessageUtils.toDeliveryOutcome((Declared)deliveryState);
            }
            case Transactional: {
                if (!(deliveryState instanceof TransactionalState)) {
                    throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Transactional delivery type should have a TransactionalState outcome."));
                }
                TransactionalState transactionalState = (TransactionalState)deliveryState;
                if (transactionalState.getTxnId() == null) {
                    throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Transactional delivery states should have an associated transaction id."));
                }
                AmqpTransaction transaction = new AmqpTransaction(transactionalState.getTxnId().asByteBuffer());
                DeliveryOutcome outcome = MessageUtils.toDeliveryOutcome(transactionalState.getOutcome());
                return new TransactionalDeliveryOutcome(transaction).setOutcome(outcome);
            }
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Delivery state not supported: " + deliveryState.getType()));
    }

    static DeliveryOutcome toDeliveryOutcome(Outcome outcome) {
        if (outcome == null) {
            return null;
        }
        if (outcome instanceof Accepted) {
            return new DeliveryOutcome(DeliveryState.ACCEPTED);
        }
        if (outcome instanceof Modified) {
            return MessageUtils.toDeliveryOutcome((Modified)outcome);
        }
        if (outcome instanceof Rejected) {
            return MessageUtils.toDeliveryOutcome((Rejected)outcome);
        }
        if (outcome instanceof Released) {
            return new DeliveryOutcome(DeliveryState.RELEASED);
        }
        if (outcome instanceof Declared) {
            return MessageUtils.toDeliveryOutcome((Declared)outcome);
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Outcome is not known: " + outcome));
    }

    static org.apache.qpid.proton.amqp.transport.DeliveryState toProtonJDeliveryState(DeliveryOutcome deliveryOutcome) {
        if (deliveryOutcome == null) {
            return null;
        }
        if (DeliveryState.ACCEPTED.equals((Object)deliveryOutcome.getDeliveryState())) {
            return Accepted.getInstance();
        }
        if (DeliveryState.REJECTED.equals((Object)deliveryOutcome.getDeliveryState())) {
            return MessageUtils.toProtonJRejected(deliveryOutcome);
        }
        if (DeliveryState.RELEASED.equals((Object)deliveryOutcome.getDeliveryState())) {
            return Released.getInstance();
        }
        if (DeliveryState.MODIFIED.equals((Object)deliveryOutcome.getDeliveryState())) {
            return MessageUtils.toProtonJModified(deliveryOutcome);
        }
        if (DeliveryState.RECEIVED.equals((Object)deliveryOutcome.getDeliveryState())) {
            if (!(deliveryOutcome instanceof ReceivedDeliveryOutcome)) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Received delivery type should be ReceivedDeliveryOutcome. Actual: " + deliveryOutcome.getClass()));
            }
            ReceivedDeliveryOutcome receivedDeliveryOutcome = (ReceivedDeliveryOutcome)deliveryOutcome;
            Received received = new Received();
            received.setSectionNumber(UnsignedInteger.valueOf((int)receivedDeliveryOutcome.getSectionNumber()));
            received.setSectionOffset(UnsignedLong.valueOf((long)receivedDeliveryOutcome.getSectionOffset()));
            return received;
        }
        if (deliveryOutcome instanceof TransactionalDeliveryOutcome) {
            TransactionalDeliveryOutcome transaction = (TransactionalDeliveryOutcome)deliveryOutcome;
            TransactionalState state = new TransactionalState();
            if (transaction.getTransactionId() == null) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Transactional deliveries require an id."));
            }
            Binary binary = Objects.requireNonNull(Binary.create((ByteBuffer)transaction.getTransactionId()), "Transaction Ids are required for a transaction.");
            state.setOutcome(MessageUtils.toProtonJOutcome(transaction.getOutcome()));
            state.setTxnId(binary);
            return state;
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Outcome could not be translated to a proton-j delivery outcome:" + (Object)((Object)deliveryOutcome.getDeliveryState())));
    }

    static Outcome toProtonJOutcome(DeliveryOutcome deliveryOutcome) {
        if (deliveryOutcome == null) {
            return null;
        }
        if (DeliveryState.ACCEPTED.equals((Object)deliveryOutcome.getDeliveryState())) {
            return Accepted.getInstance();
        }
        if (DeliveryState.REJECTED.equals((Object)deliveryOutcome.getDeliveryState())) {
            return MessageUtils.toProtonJRejected(deliveryOutcome);
        }
        if (DeliveryState.RELEASED.equals((Object)deliveryOutcome.getDeliveryState())) {
            return Released.getInstance();
        }
        if (DeliveryState.MODIFIED.equals((Object)deliveryOutcome.getDeliveryState())) {
            return MessageUtils.toProtonJModified(deliveryOutcome);
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("DeliveryOutcome cannot be converted to proton-j outcome: " + (Object)((Object)deliveryOutcome.getDeliveryState())));
    }

    private static Modified toProtonJModified(DeliveryOutcome outcome) {
        Modified modified = new Modified();
        if (!(outcome instanceof ModifiedDeliveryOutcome)) {
            return modified;
        }
        ModifiedDeliveryOutcome modifiedDeliveryOutcome = (ModifiedDeliveryOutcome)outcome;
        Map<Symbol, Object> annotations = MessageUtils.convert(modifiedDeliveryOutcome.getMessageAnnotations());
        modified.setMessageAnnotations(annotations);
        modified.setUndeliverableHere(modifiedDeliveryOutcome.isUndeliverableHere());
        modified.setDeliveryFailed(modifiedDeliveryOutcome.isDeliveryFailed());
        return modified;
    }

    private static Rejected toProtonJRejected(DeliveryOutcome outcome) {
        if (!(outcome instanceof RejectedDeliveryOutcome)) {
            return new Rejected();
        }
        Rejected rejected = new Rejected();
        RejectedDeliveryOutcome rejectedDeliveryOutcome = (RejectedDeliveryOutcome)outcome;
        AmqpErrorCondition errorCondition = rejectedDeliveryOutcome.getErrorCondition();
        if (errorCondition == null) {
            return rejected;
        }
        ErrorCondition condition = new ErrorCondition(Symbol.getSymbol((String)errorCondition.getErrorCondition()), errorCondition.toString());
        condition.setInfo(MessageUtils.convert(rejectedDeliveryOutcome.getErrorInfo()));
        rejected.setError(condition);
        return rejected;
    }

    private static DeliveryOutcome toDeliveryOutcome(Modified modified) {
        ModifiedDeliveryOutcome modifiedOutcome = new ModifiedDeliveryOutcome();
        if (modified.getDeliveryFailed() != null) {
            modifiedOutcome.setDeliveryFailed(modified.getDeliveryFailed());
        }
        if (modified.getUndeliverableHere() != null) {
            modifiedOutcome.setUndeliverableHere(modified.getUndeliverableHere());
        }
        return modifiedOutcome.setMessageAnnotations(MessageUtils.convertMap(modified.getMessageAnnotations()));
    }

    private static DeliveryOutcome toDeliveryOutcome(Rejected rejected) {
        ErrorCondition rejectedError = rejected.getError();
        if (rejectedError == null || rejectedError.getCondition() == null) {
            return new DeliveryOutcome(DeliveryState.REJECTED);
        }
        AmqpErrorCondition errorCondition = AmqpErrorCondition.fromString(rejectedError.getCondition().toString());
        if (errorCondition == null) {
            LOGGER.warning("Error condition is unknown: {}", new Object[]{rejected.getError()});
            errorCondition = AmqpErrorCondition.INTERNAL_ERROR;
        }
        return new RejectedDeliveryOutcome(errorCondition).setErrorInfo(MessageUtils.convertMap(rejectedError.getInfo()));
    }

    private static DeliveryOutcome toDeliveryOutcome(Declared declared) {
        if (declared.getTxnId() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Declared delivery states should have an associated transaction id."));
        }
        return new TransactionalDeliveryOutcome(new AmqpTransaction(declared.getTxnId().asByteBuffer()));
    }

    private static Map<String, Object> convertMap(Map map) {
        HashMap<String, Object> outcomeMessageAnnotations = new HashMap<String, Object>();
        MessageUtils.setValues(map, outcomeMessageAnnotations);
        return outcomeMessageAnnotations;
    }

    private static void setValues(Map<Symbol, Object> sourceMap, Map<String, Object> targetMap) {
        if (sourceMap == null) {
            return;
        }
        for (Map.Entry<Symbol, Object> entry : sourceMap.entrySet()) {
            targetMap.put(entry.getKey().toString(), entry.getValue());
        }
    }

    private static Map<Symbol, Object> convert(Map<String, Object> sourceMap) {
        if (sourceMap == null) {
            return null;
        }
        return sourceMap.entrySet().stream().collect(HashMap::new, (existing, entry) -> existing.put(Symbol.valueOf((String)((String)entry.getKey())), entry.getValue()), HashMap::putAll);
    }

    private MessageUtils() {
    }
}

