/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation;

import com.azure.core.amqp.AmqpTransaction;
import com.azure.core.amqp.AmqpTransactionCoordinator;
import com.azure.core.amqp.implementation.AmqpSendLink;
import com.azure.core.amqp.implementation.MessageSerializer;
import com.azure.core.util.logging.ClientLogger;
import java.nio.ByteBuffer;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.amqp.transaction.Declare;
import org.apache.qpid.proton.amqp.transaction.Declared;
import org.apache.qpid.proton.amqp.transaction.Discharge;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.message.Message;
import reactor.core.publisher.Mono;

final class TransactionCoordinator
implements AmqpTransactionCoordinator {
    private static final ClientLogger LOGGER = new ClientLogger(TransactionCoordinator.class);
    private final AmqpSendLink sendLink;
    private final MessageSerializer messageSerializer;

    TransactionCoordinator(AmqpSendLink sendLink, MessageSerializer messageSerializer) {
        this.sendLink = sendLink;
        this.messageSerializer = messageSerializer;
    }

    @Override
    public Mono<Void> discharge(AmqpTransaction transaction, boolean isCommit) {
        Message message = Proton.message();
        Discharge discharge = new Discharge();
        discharge.setFail(Boolean.valueOf(!isCommit));
        discharge.setTxnId(Binary.create((ByteBuffer)transaction.getTransactionId()));
        message.setBody((Section)new AmqpValue((Object)discharge));
        int payloadSize = this.messageSerializer.getSize(message);
        int allocationSize = payloadSize + 512;
        byte[] bytes = new byte[allocationSize];
        int encodedSize = message.encode(bytes, 0, allocationSize);
        return this.sendLink.send(bytes, encodedSize, 0, null).handle((outcome, sink) -> {
            DeliveryState.DeliveryStateType stateType = outcome.getType();
            switch (stateType) {
                case Accepted: {
                    sink.complete();
                    break;
                }
                default: {
                    sink.error((Throwable)new IllegalArgumentException("Expected a Accepted, received: " + outcome));
                    LOGGER.warning("Unknown DeliveryState type: {}", new Object[]{stateType});
                }
            }
        });
    }

    @Override
    public Mono<AmqpTransaction> declare() {
        Message message = Proton.message();
        Declare declare = new Declare();
        message.setBody((Section)new AmqpValue((Object)declare));
        int payloadSize = this.messageSerializer.getSize(message);
        int allocationSize = payloadSize + 512;
        byte[] bytes = new byte[allocationSize];
        int encodedSize = message.encode(bytes, 0, allocationSize);
        return this.sendLink.send(bytes, encodedSize, 0, null).handle((outcome, sink) -> {
            DeliveryState.DeliveryStateType stateType = outcome.getType();
            switch (stateType) {
                case Declared: {
                    Declared declared = (Declared)outcome;
                    Binary transactionId = declared.getTxnId();
                    sink.next((Object)new AmqpTransaction(transactionId.asByteBuffer()));
                    break;
                }
                default: {
                    sink.error((Throwable)new IllegalArgumentException("Expected a Declared, received: " + outcome));
                    LOGGER.warning("Unknown DeliveryState type: {}", new Object[]{stateType});
                }
            }
        });
    }
}

