/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.exception;

import com.azure.core.util.CoreUtils;
import java.io.Serializable;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class AmqpErrorContext
implements Serializable {
    static final String MESSAGE_PARAMETER_DELIMITER = ", ";
    private static final long serialVersionUID = -2819764407122954922L;
    private final String namespace;
    private final Map<String, Object> errorInfo;

    public AmqpErrorContext(String namespace) {
        if (CoreUtils.isNullOrEmpty((CharSequence)namespace)) {
            throw new IllegalArgumentException("'namespace' cannot be null or empty");
        }
        this.namespace = namespace;
        this.errorInfo = null;
    }

    public AmqpErrorContext(String namespace, Map<String, Object> errorInfo) {
        if (CoreUtils.isNullOrEmpty((CharSequence)namespace)) {
            throw new IllegalArgumentException("'namespace' cannot be null or empty");
        }
        this.namespace = namespace;
        this.errorInfo = Objects.requireNonNull(errorInfo, "'errorInfo' cannot be null.");
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Map<String, Object> getErrorInfo() {
        return this.errorInfo != null ? Collections.unmodifiableMap(this.errorInfo) : Collections.emptyMap();
    }

    public String toString() {
        String formatString = "NAMESPACE: %s. ERROR CONTEXT: %s";
        if (this.errorInfo == null) {
            return String.format(Locale.ROOT, "NAMESPACE: %s. ERROR CONTEXT: %s", this.getNamespace(), "N/A");
        }
        StringBuilder builder = new StringBuilder();
        this.errorInfo.forEach((key, value) -> builder.append(String.format("[%s: %s], ", key, value)));
        return String.format(Locale.ROOT, "NAMESPACE: %s. ERROR CONTEXT: %s", this.getNamespace(), builder.toString());
    }
}

