/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation;

import com.azure.core.amqp.AmqpEndpointState;
import com.azure.core.amqp.AmqpRetryPolicy;
import com.azure.core.amqp.exception.AmqpErrorContext;
import com.azure.core.amqp.exception.AmqpException;
import com.azure.core.amqp.implementation.StringUtil;
import com.azure.core.util.AsyncCloseable;
import com.azure.core.util.logging.ClientLogger;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import java.util.function.Function;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.util.context.Context;

public class AmqpChannelProcessor<T>
extends Mono<T>
implements Processor<T, T>,
CoreSubscriber<T>,
Disposable {
    private static final AtomicReferenceFieldUpdater<AmqpChannelProcessor, Subscription> UPSTREAM = AtomicReferenceFieldUpdater.newUpdater(AmqpChannelProcessor.class, Subscription.class, "upstream");
    private static final String TRY_COUNT_KEY = "tryCount";
    private final ClientLogger logger;
    private final AtomicBoolean isDisposed = new AtomicBoolean();
    private final AtomicBoolean isRequested = new AtomicBoolean();
    private final AtomicBoolean isRetryPending = new AtomicBoolean();
    private final AtomicInteger retryAttempts = new AtomicInteger();
    private final Object lock = new Object();
    private final AmqpRetryPolicy retryPolicy;
    private final Function<T, Flux<AmqpEndpointState>> endpointStatesFunction;
    private final AmqpErrorContext errorContext;
    private volatile Subscription upstream;
    private volatile ConcurrentLinkedDeque<ChannelSubscriber<T>> subscribers = new ConcurrentLinkedDeque();
    private volatile Throwable lastError;
    private volatile T currentChannel;
    private volatile Disposable connectionSubscription;
    private volatile Disposable retrySubscription;

    @Deprecated
    public AmqpChannelProcessor(String fullyQualifiedNamespace, String entityPath, Function<T, Flux<AmqpEndpointState>> endpointStatesFunction, AmqpRetryPolicy retryPolicy, ClientLogger logger) {
        this.endpointStatesFunction = Objects.requireNonNull(endpointStatesFunction, "'endpointStates' cannot be null.");
        this.retryPolicy = Objects.requireNonNull(retryPolicy, "'retryPolicy' cannot be null.");
        HashMap<String, String> loggingContext = new HashMap<String, String>(1);
        loggingContext.put("entityPath", Objects.requireNonNull(entityPath, "'entityPath' cannot be null."));
        this.logger = new ClientLogger(((Object)((Object)this)).getClass(), loggingContext);
        this.errorContext = new AmqpErrorContext(fullyQualifiedNamespace);
    }

    public AmqpChannelProcessor(String fullyQualifiedNamespace, Function<T, Flux<AmqpEndpointState>> endpointStatesFunction, AmqpRetryPolicy retryPolicy, Map<String, Object> loggingContext) {
        this.endpointStatesFunction = Objects.requireNonNull(endpointStatesFunction, "'endpointStates' cannot be null.");
        this.retryPolicy = Objects.requireNonNull(retryPolicy, "'retryPolicy' cannot be null.");
        this.logger = new ClientLogger(((Object)((Object)this)).getClass(), Objects.requireNonNull(loggingContext, "'loggingContext' cannot be null."));
        this.errorContext = new AmqpErrorContext(fullyQualifiedNamespace);
    }

    public void onSubscribe(Subscription subscription) {
        if (Operators.setOnce(UPSTREAM, (Object)((Object)this), (Subscription)subscription)) {
            this.isRequested.set(true);
            subscription.request(1L);
        } else {
            this.logger.warning("Processors can only be subscribed to once.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNext(T amqpChannel) {
        Disposable oldSubscription;
        T oldChannel;
        this.logger.info("Setting next AMQP channel.");
        Objects.requireNonNull(amqpChannel, "'amqpChannel' cannot be null.");
        Object object = this.lock;
        synchronized (object) {
            oldChannel = this.currentChannel;
            oldSubscription = this.connectionSubscription;
            this.currentChannel = amqpChannel;
            ConcurrentLinkedDeque<ChannelSubscriber<T>> currentSubscribers = this.subscribers;
            currentSubscribers.forEach((Consumer<ChannelSubscriber<T>>)((Consumer<ChannelSubscriber>)subscription -> subscription.onNext(amqpChannel)));
            this.connectionSubscription = this.endpointStatesFunction.apply(amqpChannel).subscribe(state -> {
                if (state == AmqpEndpointState.ACTIVE) {
                    this.retryAttempts.set(0);
                    this.logger.info("Channel is now active.");
                }
            }, error -> {
                this.setAndClearChannel();
                this.onError((Throwable)error);
            }, () -> {
                if (this.isDisposed()) {
                    this.logger.info("Channel is disposed.");
                } else {
                    this.logger.info("Channel is closed. Requesting upstream.");
                    this.setAndClearChannel();
                    this.requestUpstream();
                }
            });
        }
        this.close(oldChannel);
        if (oldSubscription != null) {
            oldSubscription.dispose();
        }
        this.isRequested.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(Throwable throwable) {
        Duration retryInterval;
        Objects.requireNonNull(throwable, "'throwable' is required.");
        if (this.isRetryPending.get() && this.retryPolicy.calculateRetryDelay(throwable, this.retryAttempts.get()) != null) {
            this.logger.warning("Retry is already pending. Ignoring transient error.", new Object[]{throwable});
            return;
        }
        int attemptsMade = this.retryAttempts.getAndIncrement();
        if (throwable instanceof AmqpException && ((AmqpException)((Object)throwable)).isTransient() || throwable instanceof IllegalStateException || throwable instanceof RejectedExecutionException) {
            int attempts = Math.min(attemptsMade, this.retryPolicy.getMaxRetries());
            Object throwableToUse = throwable instanceof AmqpException ? throwable : new AmqpException(true, "Non-AmqpException occurred upstream.", throwable, this.errorContext);
            retryInterval = this.retryPolicy.calculateRetryDelay((Throwable)throwableToUse, attempts);
        } else {
            int attempts = attemptsMade;
            retryInterval = this.retryPolicy.calculateRetryDelay(throwable, attempts);
        }
        if (retryInterval != null) {
            if (this.isRetryPending.getAndSet(true)) {
                this.retryAttempts.decrementAndGet();
                return;
            }
            this.logger.atInfo().addKeyValue(TRY_COUNT_KEY, (long)attemptsMade).addKeyValue("intervalMs", retryInterval.toMillis()).log("Transient error occurred. Retrying.", new Object[]{throwable});
            this.retrySubscription = Mono.delay((Duration)retryInterval).subscribe(i -> {
                if (this.isDisposed()) {
                    this.logger.atInfo().addKeyValue(TRY_COUNT_KEY, (long)attemptsMade).log("Not requesting from upstream. Processor is disposed.");
                } else {
                    this.logger.atInfo().addKeyValue(TRY_COUNT_KEY, (long)attemptsMade).log("Requesting from upstream.");
                    this.requestUpstream();
                    this.isRetryPending.set(false);
                }
            });
        } else {
            this.logger.atError().addKeyValue(TRY_COUNT_KEY, (long)attemptsMade).log("Retry attempts exhausted or exception was not retriable.", new Object[]{throwable});
            this.lastError = throwable;
            this.isDisposed.set(true);
            this.dispose();
            Object object = this.lock;
            synchronized (object) {
                ConcurrentLinkedDeque<ChannelSubscriber<T>> currentSubscribers = this.subscribers;
                this.subscribers = new ConcurrentLinkedDeque();
                currentSubscribers.forEach((Consumer<ChannelSubscriber<T>>)((Consumer<ChannelSubscriber>)subscriber -> subscriber.onError(throwable)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onComplete() {
        this.logger.info("Upstream connection publisher was completed. Terminating processor.");
        this.isDisposed.set(true);
        Object object = this.lock;
        synchronized (object) {
            ConcurrentLinkedDeque<ChannelSubscriber<T>> currentSubscribers = this.subscribers;
            this.subscribers = new ConcurrentLinkedDeque();
            currentSubscribers.forEach((Consumer<ChannelSubscriber<T>>)((Consumer<ChannelSubscriber>)subscriber -> subscriber.onComplete()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(CoreSubscriber<? super T> actual) {
        if (this.isDisposed()) {
            if (this.lastError != null) {
                actual.onSubscribe(Operators.emptySubscription());
                actual.onError(this.lastError);
            } else {
                IllegalStateException error = new IllegalStateException("Cannot subscribe. Processor is already terminated.");
                Operators.error(actual, (Throwable)this.logger.logExceptionAsWarning((RuntimeException)error));
            }
            return;
        }
        ChannelSubscriber subscriber = new ChannelSubscriber(actual, this);
        actual.onSubscribe(subscriber);
        Object object = this.lock;
        synchronized (object) {
            if (this.currentChannel != null) {
                subscriber.complete(this.currentChannel);
                return;
            }
        }
        subscriber.onAdd();
        this.subscribers.add(subscriber);
        if (!this.isRetryPending.get()) {
            this.requestUpstream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.isDisposed.getAndSet(true)) {
            return;
        }
        if (this.retrySubscription != null && !this.retrySubscription.isDisposed()) {
            this.retrySubscription.dispose();
        }
        this.onComplete();
        Object object = this.lock;
        synchronized (object) {
            this.setAndClearChannel();
        }
    }

    public boolean isDisposed() {
        return this.isDisposed.get();
    }

    private void requestUpstream() {
        if (this.currentChannel != null) {
            this.logger.verbose("Connection exists, not requesting another.");
            return;
        }
        if (this.isDisposed()) {
            this.logger.verbose("Is already disposed.");
            return;
        }
        Subscription subscription = UPSTREAM.get(this);
        if (subscription == null) {
            this.logger.warning("There is no upstream subscription.");
            return;
        }
        if (!this.isRequested.getAndSet(true)) {
            this.logger.info("Connection not requested, yet. Requesting one.");
            subscription.request(1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAndClearChannel() {
        T oldChannel;
        Object object = this.lock;
        synchronized (object) {
            oldChannel = this.currentChannel;
            this.currentChannel = null;
        }
        this.close(oldChannel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isChannelClosed() {
        Object object = this.lock;
        synchronized (object) {
            return this.currentChannel == null || this.isDisposed();
        }
    }

    private void close(T channel) {
        if (channel instanceof AsyncCloseable) {
            ((AsyncCloseable)channel).closeAsync().subscribe();
        } else if (channel instanceof AutoCloseable) {
            try {
                ((AutoCloseable)channel).close();
            }
            catch (Exception error) {
                this.logger.warning("Error occurred closing AutoCloseable channel.", new Object[]{error});
            }
        } else if (channel instanceof Disposable) {
            try {
                ((Disposable)channel).dispose();
            }
            catch (Exception error) {
                this.logger.warning("Error occurred closing Disposable channel.", new Object[]{error});
            }
        }
    }

    private static final class ChannelSubscriber<T>
    extends Operators.MonoSubscriber<T, T> {
        private final AmqpChannelProcessor<T> processor;
        private String subscriberId = null;

        private ChannelSubscriber(CoreSubscriber<? super T> actual, AmqpChannelProcessor<T> processor) {
            super(actual);
            this.processor = processor;
        }

        void onAdd() {
            Object subscriberIdObj = this.actual.currentContext().getOrDefault((Object)"subscriberId", null);
            this.subscriberId = subscriberIdObj != null ? subscriberIdObj.toString() : StringUtil.getRandomString("un");
            ((AmqpChannelProcessor)this.processor).logger.atVerbose().addKeyValue("subscriberId", this.subscriberId).log("Added subscriber.");
        }

        public void cancel() {
            ((AmqpChannelProcessor)this.processor).subscribers.remove((Object)this);
            super.cancel();
            ((AmqpChannelProcessor)this.processor).logger.atVerbose().addKeyValue("subscriberId", this.subscriberId).log("Canceled subscriber");
        }

        public void onComplete() {
            if (!this.isCancelled()) {
                ((AmqpChannelProcessor)this.processor).subscribers.remove((Object)this);
                this.actual.onComplete();
                ((AmqpChannelProcessor)this.processor).logger.atInfo().addKeyValue("subscriberId", this.subscriberId).log("AMQP channel processor completed.");
            }
        }

        public void onNext(T channel) {
            if (!this.isCancelled()) {
                ((AmqpChannelProcessor)this.processor).subscribers.remove((Object)this);
                super.complete(channel);
                ((AmqpChannelProcessor)this.processor).logger.atInfo().addKeyValue("subscriberId", this.subscriberId).log("Next AMQP channel received.");
            }
        }

        public void onError(Throwable throwable) {
            if (!this.isCancelled()) {
                ((AmqpChannelProcessor)this.processor).subscribers.remove((Object)this);
                this.actual.onError(throwable);
                ((AmqpChannelProcessor)this.processor).logger.atInfo().addKeyValue("subscriberId", this.subscriberId).log("Error in AMQP channel processor.");
            } else {
                Operators.onErrorDropped((Throwable)throwable, (Context)this.currentContext());
            }
        }
    }
}

