/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.management.implementation.serializer;

import com.azure.core.management.exception.ManagementError;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.regex.Pattern;

public final class ManagementErrorDeserializer
extends StdDeserializer<Object> {
    private static final long serialVersionUID = 1L;
    private static final Pattern CODE_PATTERN = Pattern.compile("\"code\"", 2);
    private static final Pattern MESSAGE_PATTERN = Pattern.compile("\"message\"", 2);
    private static final Pattern TARGET_PATTERN = Pattern.compile("\"target\"", 2);
    private static final Pattern DETAILS_PATTERN = Pattern.compile("\"details\"", 2);
    private final ObjectMapper mapper;

    private ManagementErrorDeserializer(Class<?> vc, ObjectMapper mapper) {
        super(vc);
        this.mapper = mapper;
    }

    public static SimpleModule getModule(final ObjectMapper mapper) {
        SimpleModule module = new SimpleModule();
        module.setDeserializerModifier(new BeanDeserializerModifier(){

            public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
                if (ManagementError.class.isAssignableFrom(beanDesc.getBeanClass())) {
                    return new ManagementErrorDeserializer(beanDesc.getBeanClass(), mapper);
                }
                return deserializer;
            }
        });
        return module;
    }

    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        p.setCodec((ObjectCodec)this.mapper);
        JsonNode errorNode = (JsonNode)p.readValueAsTree();
        if (errorNode == null) {
            return null;
        }
        if (errorNode.get("error") != null) {
            errorNode = errorNode.get("error");
        }
        String nodeContent = errorNode.toString();
        nodeContent = CODE_PATTERN.matcher(nodeContent).replaceFirst("\"code\"");
        nodeContent = MESSAGE_PATTERN.matcher(nodeContent).replaceFirst("\"message\"");
        nodeContent = TARGET_PATTERN.matcher(nodeContent).replaceFirst("\"target\"");
        nodeContent = DETAILS_PATTERN.matcher(nodeContent).replaceFirst("\"details\"");
        JsonParser parser = new JsonFactory().createParser(nodeContent);
        parser.setCodec((ObjectCodec)this.mapper);
        return parser.readValueAs(this.handledType());
    }
}

