/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.management;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class AzureEnvironment {
    private final Map<String, String> endpoints;
    public static final AzureEnvironment AZURE = new AzureEnvironment("https://portal.azure.com", "http://go.microsoft.com/fwlink/?LinkId=254432", "https://management.core.windows.net/", "https://management.azure.com/", "https://management.core.windows.net:8443/", ".database.windows.net", "https://gallery.azure.com/", "https://login.microsoftonline.com/", "https://management.core.windows.net/", "https://graph.windows.net/", "https://graph.microsoft.com/", "https://datalake.azure.net/", "2013-04-05", ".core.windows.net", ".vault.azure.net", "azuredatalakestore.net", "azuredatalakeanalytics.net", "https://api.loganalytics.io/", "https://api.applicationinsights.io/", ".managedhsm.azure.net");
    public static final AzureEnvironment AZURE_CHINA = new AzureEnvironment("https://portal.azure.cn", "http://go.microsoft.com/fwlink/?LinkID=301774", "https://management.core.chinacloudapi.cn/", "https://management.chinacloudapi.cn/", "https://management.core.chinacloudapi.cn:8443/", ".database.chinacloudapi.cn", "https://gallery.chinacloudapi.cn/", "https://login.chinacloudapi.cn/", "https://management.core.chinacloudapi.cn/", "https://graph.chinacloudapi.cn/", "https://microsoftgraph.chinacloudapi.cn/", "N/A", "2013-04-05", ".core.chinacloudapi.cn", ".vault.azure.cn", "N/A", "N/A", "N/A", "N/A", ".managedhsm.azure.cn");
    public static final AzureEnvironment AZURE_US_GOVERNMENT = new AzureEnvironment("https://portal.azure.us", "https://manage.windowsazure.us/publishsettings/index", "https://management.core.usgovcloudapi.net/", "https://management.usgovcloudapi.net/", "https://management.core.usgovcloudapi.net:8443/", ".database.usgovcloudapi.net", "https://gallery.usgovcloudapi.net/", "https://login.microsoftonline.us/", "https://management.core.usgovcloudapi.net/", "https://graph.windows.net/", "https://graph.microsoft.us/", "N/A", "2013-04-05", ".core.usgovcloudapi.net", ".vault.usgovcloudapi.net", "N/A", "N/A", "https://api.loganalytics.us/", "N/A", ".managedhsm.usgovcloudapi.net");
    @Deprecated
    public static final AzureEnvironment AZURE_GERMANY = new AzureEnvironment("https://portal.microsoftazure.de", "https://manage.microsoftazure.de/publishsettings/index", "https://management.core.cloudapi.de/", "https://management.microsoftazure.de/", "https://management.core.cloudapi.de:8443/", ".database.cloudapi.de", "https://gallery.cloudapi.de/", "https://login.microsoftonline.de/", "https://management.core.cloudapi.de/", "https://graph.cloudapi.de/", "https://graph.microsoft.de/", "N/A", "2013-04-05", ".core.cloudapi.de", ".vault.microsoftazure.de", "N/A", "N/A", "N/A", "N/A", "N/A");

    public AzureEnvironment(Map<String, String> endpoints) {
        this.endpoints = endpoints;
    }

    private AzureEnvironment(String portalUrl, String publishingProfileUrl, String managementEndpointUrl, String resourceManagerEndpointUrl, String sqlManagementEndpointUrl, String sqlServerHostnameSuffix, String galleryEndpointUrl, String activeDirectoryEndpointUrl, String activeDirectoryResourceId, String activeDirectoryGraphResourceId, String microsoftGraphResourceId, String dataLakeEndpointResourceId, String activeDirectoryGraphApiVersion, String storageEndpointSuffix, String keyVaultDnsSuffix, String azureDataLakeStoreFileSystemEndpointSuffix, String azureDataLakeAnalyticsCatalogAndJobEndpointSuffix, String azureLogAnalyticsResourceId, String azureApplicationInsightsResourceId, String managedHsmDnsSuffix) {
        this.endpoints = new HashMap<String, String>(26);
        this.endpoints.put("portalUrl", portalUrl);
        this.endpoints.put("publishingProfileUrl", publishingProfileUrl);
        this.endpoints.put("managementEndpointUrl", managementEndpointUrl);
        this.endpoints.put("resourceManagerEndpointUrl", resourceManagerEndpointUrl);
        this.endpoints.put("sqlManagementEndpointUrl", sqlManagementEndpointUrl);
        this.endpoints.put("sqlServerHostnameSuffix", sqlServerHostnameSuffix);
        this.endpoints.put("galleryEndpointUrl", galleryEndpointUrl);
        this.endpoints.put("activeDirectoryEndpointUrl", activeDirectoryEndpointUrl);
        this.endpoints.put("activeDirectoryResourceId", activeDirectoryResourceId);
        this.endpoints.put("activeDirectoryGraphResourceId", activeDirectoryGraphResourceId);
        this.endpoints.put("microsoftGraphResourceId", microsoftGraphResourceId);
        this.endpoints.put("dataLakeEndpointResourceId", dataLakeEndpointResourceId);
        this.endpoints.put("activeDirectoryGraphApiVersion", activeDirectoryGraphApiVersion);
        this.endpoints.put("storageEndpointSuffix", storageEndpointSuffix);
        this.endpoints.put("keyVaultDnsSuffix", keyVaultDnsSuffix);
        this.endpoints.put("azureDataLakeStoreFileSystemEndpointSuffix", azureDataLakeStoreFileSystemEndpointSuffix);
        this.endpoints.put("azureDataLakeAnalyticsCatalogAndJobEndpointSuffix", azureDataLakeAnalyticsCatalogAndJobEndpointSuffix);
        this.endpoints.put("azureLogAnalyticsResourceId", azureLogAnalyticsResourceId);
        this.endpoints.put("azureApplicationInsightsResourceId", azureApplicationInsightsResourceId);
        this.endpoints.put("managedHsmDnsSuffix", managedHsmDnsSuffix);
    }

    public Map<String, String> getEndpoints() {
        return this.endpoints;
    }

    public static List<AzureEnvironment> knownEnvironments() {
        return Arrays.asList(AZURE, AZURE_CHINA, AZURE_US_GOVERNMENT);
    }

    public String getPortal() {
        return this.endpoints.get("portalUrl");
    }

    public String getPublishingProfile() {
        return this.endpoints.get("publishingProfileUrl");
    }

    public String getManagementEndpoint() {
        return this.endpoints.get("managementEndpointUrl");
    }

    public String getResourceManagerEndpoint() {
        return this.endpoints.get("resourceManagerEndpointUrl");
    }

    public String getSqlManagementEndpoint() {
        return this.endpoints.get("sqlManagementEndpointUrl");
    }

    public String getSqlServerHostnameSuffix() {
        return this.endpoints.get("sqlServerHostnameSuffix");
    }

    public String getActiveDirectoryEndpoint() {
        return this.endpoints.get("activeDirectoryEndpointUrl").replaceAll("/$", "") + "/";
    }

    public String getActiveDirectoryResourceId() {
        return this.endpoints.get("activeDirectoryResourceId");
    }

    public String getGalleryEndpoint() {
        return this.endpoints.get("galleryEndpointUrl");
    }

    public String getGraphEndpoint() {
        return this.endpoints.get("activeDirectoryGraphResourceId");
    }

    public String getMicrosoftGraphEndpoint() {
        return this.endpoints.get("microsoftGraphResourceId");
    }

    public String getDataLakeEndpointResourceId() {
        return this.endpoints.get("dataLakeEndpointResourceId");
    }

    public String getActiveDirectoryGraphApiVersion() {
        return this.endpoints.get("activeDirectoryGraphApiVersion");
    }

    public String getStorageEndpointSuffix() {
        return this.endpoints.get("storageEndpointSuffix");
    }

    public String getKeyVaultDnsSuffix() {
        return this.endpoints.get("keyVaultDnsSuffix");
    }

    public String getAzureDataLakeStoreFileSystemEndpointSuffix() {
        return this.endpoints.get("azureDataLakeStoreFileSystemEndpointSuffix");
    }

    public String getAzureDataLakeAnalyticsCatalogAndJobEndpointSuffix() {
        return this.endpoints.get("azureDataLakeAnalyticsCatalogAndJobEndpointSuffix");
    }

    public String getLogAnalyticsEndpoint() {
        return this.endpoints.get("azureLogAnalyticsResourceId");
    }

    public String getApplicationInsightsEndpoint() {
        return this.endpoints.get("azureApplicationInsightsResourceId");
    }

    public String getUrlByEndpoint(Endpoint endpoint) {
        return this.endpoints.get(endpoint.identifier());
    }

    public static enum Endpoint {
        MANAGEMENT("managementEndpointUrl"),
        RESOURCE_MANAGER("resourceManagerEndpointUrl"),
        SQL("sqlManagementEndpointUrl"),
        GALLERY("galleryEndpointUrl"),
        ACTIVE_DIRECTORY("activeDirectoryEndpointUrl"),
        GRAPH("activeDirectoryGraphResourceId"),
        KEYVAULT("keyVaultDnsSuffix"),
        DATA_LAKE_STORE("azureDataLakeStoreFileSystemEndpointSuffix"),
        DATA_LAKE_ANALYTICS("azureDataLakeAnalyticsCatalogAndJobEndpointSuffix"),
        LOG_ANALYTICS("azureLogAnalyticsResourceId"),
        APPLICATION_INSIGHTS("azureApplicationInsightsResourceId"),
        MICROSOFT_GRAPH("microsoftGraphResourceId"),
        MANAGED_HSM("managedHsmDnsSuffix");

        private final String field;

        private Endpoint(String value) {
            this.field = value;
        }

        public String identifier() {
            return this.field;
        }

        public String toString() {
            return this.field;
        }
    }
}

