/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Locale;
import java.util.Objects;

public final class HttpHeaderName
extends ExpandableStringEnum<HttpHeaderName> {
    private String caseInsensitive;
    public static final HttpHeaderName ACCEPT = HttpHeaderName.fromString("Accept");
    public static final HttpHeaderName ACCEPT_CHARSET = HttpHeaderName.fromString("Accept-Charset");
    public static final HttpHeaderName ACCESS_CONTROL_ALLOW_CREDENTIALS = HttpHeaderName.fromString("Access-Control-Allow-Credentials");
    public static final HttpHeaderName ACCESS_CONTROL_ALLOW_HEADERS = HttpHeaderName.fromString("Access-Control-Allow-Headers");
    public static final HttpHeaderName ACCESS_CONTROL_ALLOW_METHODS = HttpHeaderName.fromString("Access-Control-Allow-Methods");
    public static final HttpHeaderName ACCESS_CONTROL_ALLOW_ORIGIN = HttpHeaderName.fromString("Access-Control-Allow-Origin");
    public static final HttpHeaderName ACCESS_CONTROL_EXPOSE_HEADERS = HttpHeaderName.fromString("Access-Control-Expose-Headers");
    public static final HttpHeaderName ACCESS_CONTROL_MAX_AGE = HttpHeaderName.fromString("Access-Control-Max-Age");
    public static final HttpHeaderName ACCEPT_DATETIME = HttpHeaderName.fromString("Accept-Datetime");
    public static final HttpHeaderName ACCEPT_ENCODING = HttpHeaderName.fromString("Accept-Encoding");
    public static final HttpHeaderName ACCEPT_LANGUAGE = HttpHeaderName.fromString("Accept-Language");
    public static final HttpHeaderName ACCEPT_PATCH = HttpHeaderName.fromString("Accept-Patch");
    public static final HttpHeaderName ACCEPT_RANGES = HttpHeaderName.fromString("Accept-Ranges");
    public static final HttpHeaderName AGE = HttpHeaderName.fromString("Age");
    public static final HttpHeaderName ALLOW = HttpHeaderName.fromString("Allow");
    public static final HttpHeaderName AUTHORIZATION = HttpHeaderName.fromString("Authorization");
    public static final HttpHeaderName CACHE_CONTROL = HttpHeaderName.fromString("Cache-Control");
    public static final HttpHeaderName CONNECTION = HttpHeaderName.fromString("Connection");
    public static final HttpHeaderName CONTENT_DISPOSITION = HttpHeaderName.fromString("Content-Disposition");
    public static final HttpHeaderName CONTENT_ENCODING = HttpHeaderName.fromString("Content-Encoding");
    public static final HttpHeaderName CONTENT_LANGUAGE = HttpHeaderName.fromString("Content-Language");
    public static final HttpHeaderName CONTENT_LENGTH = HttpHeaderName.fromString("Content-Length");
    public static final HttpHeaderName CONTENT_LOCATION = HttpHeaderName.fromString("Content-Location");
    public static final HttpHeaderName CONTENT_MD5 = HttpHeaderName.fromString("Content-MD5");
    public static final HttpHeaderName CONTENT_RANGE = HttpHeaderName.fromString("Content-Range");
    public static final HttpHeaderName CONTENT_TYPE = HttpHeaderName.fromString("Content-Type");
    public static final HttpHeaderName COOKIE = HttpHeaderName.fromString("Cookie");
    public static final HttpHeaderName DATE = HttpHeaderName.fromString("Date");
    public static final HttpHeaderName ETAG = HttpHeaderName.fromString("ETag");
    public static final HttpHeaderName EXPECT = HttpHeaderName.fromString("Expect");
    public static final HttpHeaderName EXPIRES = HttpHeaderName.fromString("Expires");
    public static final HttpHeaderName FORWARDED = HttpHeaderName.fromString("Forwarded");
    public static final HttpHeaderName FROM = HttpHeaderName.fromString("From");
    public static final HttpHeaderName HOST = HttpHeaderName.fromString("Host");
    public static final HttpHeaderName HTTP2_SETTINGS = HttpHeaderName.fromString("HTTP2-Settings");
    public static final HttpHeaderName IF_MATCH = HttpHeaderName.fromString("If-Match");
    public static final HttpHeaderName IF_MODIFIED_SINCE = HttpHeaderName.fromString("If-Modified-Since");
    public static final HttpHeaderName IF_NONE_MATCH = HttpHeaderName.fromString("If-None-Match");
    public static final HttpHeaderName IF_RANGE = HttpHeaderName.fromString("If-Range");
    public static final HttpHeaderName IF_UNMODIFIED_SINCE = HttpHeaderName.fromString("If-Unmodified-Since");
    public static final HttpHeaderName LAST_MODIFIED = HttpHeaderName.fromString("Last-Modified");
    public static final HttpHeaderName LINK = HttpHeaderName.fromString("Link");
    public static final HttpHeaderName LOCATION = HttpHeaderName.fromString("Location");
    public static final HttpHeaderName MAX_FORWARDS = HttpHeaderName.fromString("Max-Forwards");
    public static final HttpHeaderName ORIGIN = HttpHeaderName.fromString("Origin");
    public static final HttpHeaderName PRAGMA = HttpHeaderName.fromString("Pragma");
    public static final HttpHeaderName PREFER = HttpHeaderName.fromString("Prefer");
    public static final HttpHeaderName PREFERENCE_APPLIED = HttpHeaderName.fromString("Preference-Applied");
    public static final HttpHeaderName PROXY_AUTHENTICATE = HttpHeaderName.fromString("Proxy-Authenticate");
    public static final HttpHeaderName PROXY_AUTHORIZATION = HttpHeaderName.fromString("Proxy-Authorization");
    public static final HttpHeaderName RANGE = HttpHeaderName.fromString("Range");
    public static final HttpHeaderName REFERER = HttpHeaderName.fromString("Referer");
    public static final HttpHeaderName RETRY_AFTER = HttpHeaderName.fromString("Retry-After");
    public static final HttpHeaderName SERVER = HttpHeaderName.fromString("Server");
    public static final HttpHeaderName SET_COOKIE = HttpHeaderName.fromString("Set-Cookie");
    public static final HttpHeaderName STRICT_TRANSPORT_SECURITY = HttpHeaderName.fromString("Strict-Transport-Security");
    public static final HttpHeaderName TE = HttpHeaderName.fromString("TE");
    public static final HttpHeaderName TRAILER = HttpHeaderName.fromString("Trailer");
    public static final HttpHeaderName TRANSFER_ENCODING = HttpHeaderName.fromString("Transfer-Encoding");
    public static final HttpHeaderName USER_AGENT = HttpHeaderName.fromString("User-Agent");
    public static final HttpHeaderName UPGRADE = HttpHeaderName.fromString("Upgrade");
    public static final HttpHeaderName VARY = HttpHeaderName.fromString("Vary");
    public static final HttpHeaderName VIA = HttpHeaderName.fromString("Via");
    public static final HttpHeaderName WARNING = HttpHeaderName.fromString("Warning");
    public static final HttpHeaderName WWW_AUTHENTICATE = HttpHeaderName.fromString("WWW-Authenticate");
    public static final HttpHeaderName X_MS_CLIENT_REQUEST_ID = HttpHeaderName.fromString("x-ms-client-request-id");
    public static final HttpHeaderName X_MS_REQUEST_ID = HttpHeaderName.fromString("x-ms-request-id");
    public static final HttpHeaderName TRACEPARENT = HttpHeaderName.fromString("traceparent");

    @Deprecated
    public HttpHeaderName() {
    }

    public String getCaseSensitiveName() {
        return this.toString();
    }

    public String getCaseInsensitiveName() {
        return this.caseInsensitive;
    }

    public static HttpHeaderName fromString(String name) {
        if (name == null) {
            return null;
        }
        HttpHeaderName headerName = HttpHeaderName.fromString(name, HttpHeaderName.class);
        headerName.caseInsensitive = name.toLowerCase(Locale.ROOT);
        return headerName;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.caseInsensitive);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HttpHeaderName)) {
            return false;
        }
        HttpHeaderName other = (HttpHeaderName)obj;
        return Objects.equals(this.caseInsensitive, other.caseInsensitive);
    }
}

