/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.implementation.util.EnvironmentConfiguration;
import com.azure.core.util.ConfigurationProperty;
import com.azure.core.util.ConfigurationSource;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.NoopConfiguration;
import com.azure.core.util.logging.ClientLogger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class Configuration
implements Cloneable {
    public static final String PROPERTY_HTTP_PROXY = "HTTP_PROXY";
    public static final String PROPERTY_HTTPS_PROXY = "HTTPS_PROXY";
    public static final String PROPERTY_IDENTITY_ENDPOINT = "IDENTITY_ENDPOINT";
    public static final String PROPERTY_IDENTITY_HEADER = "IDENTITY_HEADER";
    public static final String PROPERTY_NO_PROXY = "NO_PROXY";
    public static final String PROPERTY_MSI_ENDPOINT = "MSI_ENDPOINT";
    public static final String PROPERTY_MSI_SECRET = "MSI_SECRET";
    public static final String PROPERTY_AZURE_SUBSCRIPTION_ID = "AZURE_SUBSCRIPTION_ID";
    public static final String PROPERTY_AZURE_USERNAME = "AZURE_USERNAME";
    public static final String PROPERTY_AZURE_PASSWORD = "AZURE_PASSWORD";
    public static final String PROPERTY_AZURE_CLIENT_ID = "AZURE_CLIENT_ID";
    public static final String PROPERTY_AZURE_CLIENT_SECRET = "AZURE_CLIENT_SECRET";
    public static final String PROPERTY_AZURE_TENANT_ID = "AZURE_TENANT_ID";
    public static final String PROPERTY_AZURE_CLIENT_CERTIFICATE_PATH = "AZURE_CLIENT_CERTIFICATE_PATH";
    public static final String PROPERTY_AZURE_CLIENT_CERTIFICATE_PASSWORD = "AZURE_CLIENT_CERTIFICATE_PASSWORD";
    public static final String PROPERTY_AZURE_IDENTITY_DISABLE_CP1 = "AZURE_IDENTITY_DISABLE_CP1";
    public static final String PROPERTY_AZURE_POD_IDENTITY_TOKEN_URL = "AZURE_POD_IDENTITY_TOKEN_URL";
    public static final String PROPERTY_AZURE_REGIONAL_AUTHORITY_NAME = "AZURE_REGIONAL_AUTHORITY_NAME";
    public static final String PROPERTY_AZURE_RESOURCE_GROUP = "AZURE_RESOURCE_GROUP";
    public static final String PROPERTY_AZURE_CLOUD = "AZURE_CLOUD";
    public static final String PROPERTY_AZURE_AUTHORITY_HOST = "AZURE_AUTHORITY_HOST";
    public static final String PROPERTY_AZURE_TELEMETRY_DISABLED = "AZURE_TELEMETRY_DISABLED";
    public static final String PROPERTY_AZURE_LOG_LEVEL = "AZURE_LOG_LEVEL";
    public static final String PROPERTY_AZURE_HTTP_LOG_DETAIL_LEVEL = "AZURE_HTTP_LOG_DETAIL_LEVEL";
    public static final String PROPERTY_AZURE_TRACING_DISABLED = "AZURE_TRACING_DISABLED";
    public static final String PROPERTY_AZURE_TRACING_IMPLEMENTATION = "AZURE_TRACING_IMPLEMENTATION";
    public static final String PROPERTY_AZURE_METRICS_DISABLED = "AZURE_METRICS_DISABLED";
    public static final String PROPERTY_AZURE_METRICS_IMPLEMENTATION = "AZURE_METRICS_IMPLEMENTATION";
    public static final String PROPERTY_AZURE_REQUEST_RETRY_COUNT = "AZURE_REQUEST_RETRY_COUNT";
    public static final String PROPERTY_AZURE_REQUEST_CONNECT_TIMEOUT = "AZURE_REQUEST_CONNECT_TIMEOUT";
    public static final String PROPERTY_AZURE_REQUEST_WRITE_TIMEOUT = "AZURE_REQUEST_WRITE_TIMEOUT";
    public static final String PROPERTY_AZURE_REQUEST_RESPONSE_TIMEOUT = "AZURE_REQUEST_RESPONSE_TIMEOUT";
    public static final String PROPERTY_AZURE_REQUEST_READ_TIMEOUT = "AZURE_REQUEST_READ_TIMEOUT";
    public static final String PROPERTY_AZURE_HTTP_CLIENT_IMPLEMENTATION = "AZURE_HTTP_CLIENT_IMPLEMENTATION";
    private static final Configuration GLOBAL_CONFIGURATION = new Configuration();
    public static final Configuration NONE = new NoopConfiguration();
    private static final ClientLogger LOGGER = new ClientLogger(Configuration.class);
    private final EnvironmentConfiguration environmentConfiguration;
    private final Map<String, String> configurations;
    private final String path;
    private final Configuration sharedConfiguration;
    private final boolean isEmpty;

    @Deprecated
    public Configuration() {
        this(Collections.emptyMap(), EnvironmentConfiguration.getGlobalConfiguration(), null, null);
    }

    Configuration(ConfigurationSource configurationSource, EnvironmentConfiguration environmentConfiguration, String path, Configuration sharedConfiguration) {
        this(Configuration.readConfigurations(configurationSource, path), environmentConfiguration, path, sharedConfiguration);
    }

    private Configuration(Map<String, String> configurations, EnvironmentConfiguration environmentConfiguration, String path, Configuration sharedConfiguration) {
        this.configurations = configurations;
        this.isEmpty = configurations.isEmpty();
        this.environmentConfiguration = Objects.requireNonNull(environmentConfiguration, "'environmentConfiguration' cannot be null");
        this.path = path;
        this.sharedConfiguration = sharedConfiguration;
    }

    public static Configuration getGlobalConfiguration() {
        return GLOBAL_CONFIGURATION;
    }

    public String get(String name) {
        return this.environmentConfiguration.get(name);
    }

    public <T> T get(String name, T defaultValue) {
        return Configuration.convertToPrimitiveOrDefault(this.get(name), defaultValue);
    }

    public <T> T get(String name, Function<String, T> converter) {
        Objects.requireNonNull(converter, "'converter' can't be null");
        return converter.apply(this.get(name));
    }

    @Deprecated
    public Configuration put(String name, String value) {
        this.environmentConfiguration.put(name, value);
        return this;
    }

    @Deprecated
    public String remove(String name) {
        return this.environmentConfiguration.remove(name);
    }

    public boolean contains(String name) {
        return this.get(name) != null;
    }

    @Deprecated
    public Configuration clone() {
        return new Configuration(this.configurations, new EnvironmentConfiguration(this.environmentConfiguration), this.path, this.sharedConfiguration);
    }

    public boolean contains(ConfigurationProperty<?> property) {
        Objects.requireNonNull(property, "'property' can't be null");
        return this.getWithFallback(property) != null;
    }

    public <T> T get(ConfigurationProperty<T> property) {
        Objects.requireNonNull(property, "'property' cannot be null");
        String value = this.getWithFallback(property);
        if (value == null) {
            if (property.isRequired()) {
                throw LOGGER.atError().addKeyValue("name", property.getName()).addKeyValue("path", this.path).log(new IllegalArgumentException("Missing required property."));
            }
            return property.getDefaultValue();
        }
        try {
            return property.getConverter().apply(value);
        }
        catch (RuntimeException ex) {
            throw LOGGER.atError().addKeyValue("name", property.getName()).addKeyValue("path", this.path).addKeyValue("value", property.getValueSanitizer().apply(value)).log(ex);
        }
    }

    private String getLocalProperty(String name, Iterable<String> aliases, Function<String, String> valueSanitizer) {
        if (this.isEmpty) {
            return null;
        }
        String value = this.configurations.get(name);
        if (value != null) {
            LOGGER.atVerbose().addKeyValue("name", name).addKeyValue("path", this.path).addKeyValue("value", () -> (String)valueSanitizer.apply(value)).log("Got property value by name.");
            return value;
        }
        for (String alias : aliases) {
            String valueByAlias = this.configurations.get(alias);
            if (valueByAlias == null) continue;
            LOGGER.atVerbose().addKeyValue("name", name).addKeyValue("path", this.path).addKeyValue("alias", alias).addKeyValue("value", () -> (String)valueSanitizer.apply(valueByAlias)).log("Got property value by alias.");
            return valueByAlias;
        }
        return null;
    }

    private String getWithFallback(ConfigurationProperty<?> property) {
        String name = property.getName();
        if (!CoreUtils.isNullOrEmpty(name)) {
            String value = this.getLocalProperty(name, property.getAliases(), property.getValueSanitizer());
            if (value != null) {
                return value;
            }
            if (property.isShared() && this.sharedConfiguration != null && (value = this.sharedConfiguration.getLocalProperty(name, property.getAliases(), property.getValueSanitizer())) != null) {
                return value;
            }
        }
        return this.getFromEnvironment(property.getSystemPropertyName(), property.getEnvironmentVariableName(), property.getValueSanitizer());
    }

    String getFromEnvironment(String systemProperty, String envVar, Function<String, String> valueSanitizer) {
        String value;
        if (systemProperty != null && (value = this.environmentConfiguration.getSystemProperty(systemProperty)) != null) {
            LOGGER.atVerbose().addKeyValue("systemProperty", systemProperty).addKeyValue("value", () -> (String)valueSanitizer.apply(value)).log("Got property from system property.");
            return value;
        }
        if (envVar != null && (value = this.environmentConfiguration.getEnvironmentVariable(envVar)) != null) {
            LOGGER.atVerbose().addKeyValue("envVar", envVar).addKeyValue("value", () -> (String)valueSanitizer.apply(value)).log("Got property from environment variable.");
            return value;
        }
        return null;
    }

    private static Map<String, String> readConfigurations(ConfigurationSource source, String path) {
        Objects.requireNonNull(source, "'source' cannot be null");
        Map<String, String> configs = source.getProperties(path);
        if (configs == null || configs.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> props = new HashMap<String, String>();
        for (Map.Entry<String, String> prop : configs.entrySet()) {
            String key = CoreUtils.isNullOrEmpty(path) ? prop.getKey() : prop.getKey().substring(path.length() + 1);
            String value = prop.getValue();
            LOGGER.atVerbose().addKeyValue("name", prop.getKey()).log("Got property from configuration source.");
            if (key != null && value != null) {
                props.put(key, value);
                continue;
            }
            LOGGER.atWarning().addKeyValue("name", prop.getKey()).log("Key or value is null, property is ignored.");
        }
        return props;
    }

    private static <T> T convertToPrimitiveOrDefault(String value, T defaultValue) {
        if (CoreUtils.isNullOrEmpty(value)) {
            return defaultValue;
        }
        Object convertedValue = defaultValue instanceof Byte ? Byte.valueOf(Byte.parseByte(value)) : (defaultValue instanceof Short ? Short.valueOf(Short.parseShort(value)) : (defaultValue instanceof Integer ? Integer.valueOf(Integer.parseInt(value)) : (defaultValue instanceof Long ? Long.valueOf(Long.parseLong(value)) : (defaultValue instanceof Float ? Float.valueOf(Float.parseFloat(value)) : (defaultValue instanceof Double ? Double.valueOf(Double.parseDouble(value)) : (defaultValue instanceof Boolean ? Boolean.valueOf(Boolean.parseBoolean(value)) : value))))));
        return (T)convertedValue;
    }
}

