/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.CosmosItemSerializer;
import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.util.Beta;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.Duration;

@Beta(value=Beta.SinceVersion.V4_12_0, warningText="Preview API - subject to change in non-backwards compatible way")
public final class ChangeFeedPolicy {
    private final JsonSerializable jsonSerializable;

    @Deprecated
    @Beta(value=Beta.SinceVersion.V4_12_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static ChangeFeedPolicy createFullFidelityPolicy(Duration retentionDuration) {
        if (retentionDuration.isNegative() || retentionDuration.isZero() || retentionDuration.getNano() != 0 || retentionDuration.getSeconds() % 60L != 0L) {
            throw new IllegalArgumentException("Argument retentionDuration must be a duration of a positive number of minutes.");
        }
        ChangeFeedPolicy policy = new ChangeFeedPolicy();
        policy.setRetentionDurationForAllVersionsAndDeletesPolicyInMinutes((int)retentionDuration.toMinutes());
        return policy;
    }

    @Beta(value=Beta.SinceVersion.V4_37_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static ChangeFeedPolicy createAllVersionsAndDeletesPolicy(Duration retentionDuration) {
        if (retentionDuration.isNegative() || retentionDuration.isZero() || retentionDuration.getNano() != 0 || retentionDuration.getSeconds() % 60L != 0L) {
            throw new IllegalArgumentException("Argument retentionDuration must be a duration of a positive number of minutes.");
        }
        ChangeFeedPolicy policy = new ChangeFeedPolicy();
        policy.setRetentionDurationForAllVersionsAndDeletesPolicyInMinutes((int)retentionDuration.toMinutes());
        return policy;
    }

    @Deprecated
    @Beta(value=Beta.SinceVersion.V4_12_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static ChangeFeedPolicy createIncrementalPolicy() {
        ChangeFeedPolicy policy = new ChangeFeedPolicy();
        policy.setRetentionDurationForAllVersionsAndDeletesPolicyInMinutes(null);
        return policy;
    }

    @Beta(value=Beta.SinceVersion.V4_37_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static ChangeFeedPolicy createLatestVersionPolicy() {
        ChangeFeedPolicy policy = new ChangeFeedPolicy();
        policy.setRetentionDurationForAllVersionsAndDeletesPolicyInMinutes(null);
        return policy;
    }

    ChangeFeedPolicy() {
        this.jsonSerializable = new JsonSerializable();
    }

    ChangeFeedPolicy(String jsonString) {
        this.jsonSerializable = new JsonSerializable(jsonString);
    }

    ChangeFeedPolicy(ObjectNode objectNode) {
        this.jsonSerializable = new JsonSerializable(objectNode);
    }

    @Deprecated
    @Beta(value=Beta.SinceVersion.V4_12_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public Duration getFullFidelityRetentionDuration() {
        return this.getRetentionDurationForAllVersionsAndDeletesPolicy();
    }

    @Beta(value=Beta.SinceVersion.V4_37_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public Duration getRetentionDurationForAllVersionsAndDeletesPolicy() {
        return Duration.ofMinutes(this.getRetentionDurationForAllVersionsAndDeletesPolicyInMinutes());
    }

    int getRetentionDurationForAllVersionsAndDeletesPolicyInMinutes() {
        Integer intValue = this.jsonSerializable.getInt("retentionDuration");
        if (intValue == null || intValue < 0) {
            return 0;
        }
        return intValue;
    }

    ChangeFeedPolicy setRetentionDurationForAllVersionsAndDeletesPolicyInMinutes(Integer retentionDurationInMinutes) {
        if (retentionDurationInMinutes == null || retentionDurationInMinutes <= 0) {
            this.jsonSerializable.set("retentionDuration", 0, CosmosItemSerializer.DEFAULT_SERIALIZER);
        } else {
            this.jsonSerializable.set("retentionDuration", retentionDurationInMinutes, CosmosItemSerializer.DEFAULT_SERIALIZER);
        }
        return this;
    }

    void populatePropertyBag() {
        this.jsonSerializable.populatePropertyBag();
    }

    JsonSerializable getJsonSerializable() {
        return this.jsonSerializable;
    }
}

