/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.CosmosItemSerializer;
import com.azure.cosmos.implementation.HashIndex;
import com.azure.cosmos.implementation.Index;
import com.azure.cosmos.implementation.IndexKind;
import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.RangeIndex;
import com.azure.cosmos.implementation.SpatialIndex;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class IncludedPath {
    private List<Index> indexes;
    private JsonSerializable jsonSerializable;

    public IncludedPath(String path) {
        this.jsonSerializable = new JsonSerializable();
        this.setPath(path);
    }

    IncludedPath(ObjectNode objectNode) {
        this.jsonSerializable = new JsonSerializable(objectNode);
    }

    public String getPath() {
        return this.jsonSerializable.getString("path");
    }

    public IncludedPath setPath(String path) {
        this.jsonSerializable.set("path", path, CosmosItemSerializer.DEFAULT_SERIALIZER);
        return this;
    }

    List<Index> getIndexes() {
        if (this.indexes == null) {
            this.indexes = this.getIndexCollection();
            if (this.indexes == null) {
                this.indexes = new ArrayList<Index>();
            }
        }
        return this.indexes;
    }

    IncludedPath setIndexes(List<Index> indexes) {
        this.indexes = indexes;
        return this;
    }

    private List<Index> getIndexCollection() {
        if (this.jsonSerializable.getPropertyBag() != null && this.jsonSerializable.getPropertyBag().has("indexes")) {
            ArrayNode jsonArray = (ArrayNode)this.jsonSerializable.getPropertyBag().get("indexes");
            ArrayList<Index> result = new ArrayList<Index>();
            block5: for (int i = 0; i < jsonArray.size(); ++i) {
                JsonNode jsonObject = jsonArray.get(i);
                IndexKind indexKind = IndexKind.valueOf(StringUtils.upperCase(jsonObject.get("kind").asText()));
                switch (indexKind) {
                    case HASH: {
                        result.add(new HashIndex(jsonObject.toString()));
                        continue block5;
                    }
                    case RANGE: {
                        result.add(new RangeIndex(jsonObject.toString()));
                        continue block5;
                    }
                    case SPATIAL: {
                        result.add(new SpatialIndex(jsonObject.toString()));
                        continue block5;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected value: " + (Object)((Object)indexKind));
                    }
                }
            }
            return result;
        }
        return null;
    }

    void populatePropertyBag() {
        this.jsonSerializable.populatePropertyBag();
        if (this.indexes != null) {
            for (Index index : this.indexes) {
                index.populatePropertyBag();
            }
            this.jsonSerializable.set("indexes", this.indexes, CosmosItemSerializer.DEFAULT_SERIALIZER);
        }
    }

    JsonSerializable getJsonSerializable() {
        return this.jsonSerializable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncludedPath that = (IncludedPath)o;
        return Objects.equals(this.jsonSerializable, that.jsonSerializable);
    }

    public int hashCode() {
        return Objects.hash(this.jsonSerializable);
    }
}

