/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.http;

import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Http2ResponseHeaderCleanerHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(Http2ResponseHeaderCleanerHandler.class);

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof Http2HeadersFrame) {
            Http2HeadersFrame headersFrame = (Http2HeadersFrame)msg;
            Http2Headers headers = headersFrame.headers();
            headers.forEach(entry -> {
                CharSequence key = (CharSequence)entry.getKey();
                CharSequence value = (CharSequence)entry.getValue();
                if (StringUtils.equalsIgnoreCase(key, "x-ms-serviceversion") && StringUtils.isNotEmpty(value) && (value.charAt(0) == ' ' || value.charAt(value.length() - 1) == ' ')) {
                    logger.trace("There are extra white space for key {} with value {}", (Object)key, (Object)value);
                    headers.set((Object)key, (Object)value.toString().trim());
                }
            });
        }
        super.channelRead(ctx, msg);
    }
}

