/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosDiagnostics;
import com.azure.cosmos.implementation.DocumentClientRetryPolicy;
import com.azure.cosmos.implementation.GlobalEndpointManager;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.circuitBreaker.GlobalPartitionEndpointManagerForCircuitBreaker;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.query.Fetcher;
import com.azure.cosmos.implementation.spark.OperationContextAndListenerTuple;
import com.azure.cosmos.models.FeedResponse;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import reactor.core.publisher.Mono;

class ServerSideOnlyContinuationFetcherImpl<T>
extends Fetcher<T> {
    private final BiFunction<String, Integer, RxDocumentServiceRequest> createRequestFunc;
    private volatile String continuationToken;

    public ServerSideOnlyContinuationFetcherImpl(BiFunction<String, Integer, RxDocumentServiceRequest> createRequestFunc, Function<RxDocumentServiceRequest, Mono<FeedResponse<T>>> executeFunc, String continuationToken, boolean isChangeFeed, int top, int maxItemCount, OperationContextAndListenerTuple operationContext, List<CosmosDiagnostics> cancelledRequestDiagnosticsTracker, GlobalEndpointManager globalEndpointManager, GlobalPartitionEndpointManagerForCircuitBreaker globalPartitionEndpointManagerForCircuitBreaker) {
        super(executeFunc, isChangeFeed, top, maxItemCount, operationContext, cancelledRequestDiagnosticsTracker, globalEndpointManager, globalPartitionEndpointManagerForCircuitBreaker);
        Preconditions.checkNotNull(createRequestFunc, "Argument 'createRequestFunc' must not be null.");
        this.createRequestFunc = createRequestFunc;
        this.continuationToken = continuationToken;
    }

    @Override
    protected String applyServerResponseContinuation(String serverContinuationToken, RxDocumentServiceRequest request, FeedResponse<T> response) {
        this.continuationToken = serverContinuationToken;
        return this.continuationToken;
    }

    @Override
    protected boolean isFullyDrained(boolean isChangeFeed, FeedResponse<T> response) {
        return StringUtils.isEmpty(this.continuationToken) || isChangeFeed && BridgeInternal.noChanges(response);
    }

    @Override
    protected String getContinuationForLogging() {
        return this.continuationToken;
    }

    @Override
    protected RxDocumentServiceRequest createRequest(int maxItemCount, DocumentClientRetryPolicy documentClientRetryPolicy) {
        return this.createRequestFunc.apply(this.continuationToken, maxItemCount);
    }
}

