/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;

public enum CosmosVectorDataType {
    INT8("int8"),
    UINT8("uint8"),
    FLOAT16("float16"),
    FLOAT32("float32");

    private final String overWireValue;

    private CosmosVectorDataType(String overWireValue) {
        this.overWireValue = overWireValue;
    }

    @JsonValue
    public String toString() {
        return this.overWireValue;
    }

    public static CosmosVectorDataType fromString(String value) {
        return Arrays.stream(CosmosVectorDataType.values()).filter(vectorDataType -> vectorDataType.toString().equalsIgnoreCase(value)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Invalid vector data type with value {%s} for the vector embedding policy.", value)));
    }
}

