/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.extensions.implementation.template;

import com.azure.core.credential.AccessToken;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.extensions.implementation.credential.TokenCredentialProviderOptions;
import com.azure.identity.extensions.implementation.credential.provider.TokenCredentialProvider;
import com.azure.identity.extensions.implementation.token.AccessTokenResolver;
import com.azure.identity.extensions.implementation.token.AccessTokenResolverOptions;
import java.time.Duration;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;

public class AzureAuthenticationTemplate {
    private static final ClientLogger LOGGER = new ClientLogger(AzureAuthenticationTemplate.class);
    private final AtomicBoolean isInitialized = new AtomicBoolean(false);
    private TokenCredentialProvider tokenCredentialProvider;
    private AccessTokenResolver accessTokenResolver;

    public AzureAuthenticationTemplate() {
        this.tokenCredentialProvider = null;
        this.accessTokenResolver = null;
    }

    public AzureAuthenticationTemplate(TokenCredentialProvider tokenCredentialProvider, AccessTokenResolver accessTokenResolver) {
        this.tokenCredentialProvider = tokenCredentialProvider;
        this.accessTokenResolver = accessTokenResolver;
    }

    public void init(Properties properties) {
        if (this.isInitialized.compareAndSet(false, true)) {
            LOGGER.verbose("Initializing AzureAuthenticationTemplate.");
            if (this.getTokenCredentialProvider() == null) {
                this.tokenCredentialProvider = TokenCredentialProvider.createDefault(new TokenCredentialProviderOptions(properties));
            }
            if (this.getAccessTokenResolver() == null) {
                this.accessTokenResolver = AccessTokenResolver.createDefault(new AccessTokenResolverOptions(properties));
            }
            LOGGER.verbose("Initialized AzureAuthenticationTemplate.");
        } else {
            LOGGER.info("AzureAuthenticationTemplate has already initialized.");
        }
    }

    public Mono<String> getTokenAsPasswordAsync() {
        if (!this.isInitialized.get()) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("must call init() first"));
        }
        return Mono.fromSupplier((Supplier)this.getTokenCredentialProvider()).flatMap((Function)this.getAccessTokenResolver()).filter(token -> !token.isExpired()).map(AccessToken::getToken);
    }

    public String getTokenAsPassword() {
        return (String)this.getTokenAsPasswordAsync().block(this.getBlockTimeout());
    }

    AccessTokenResolver getAccessTokenResolver() {
        return this.accessTokenResolver;
    }

    TokenCredentialProvider getTokenCredentialProvider() {
        return this.tokenCredentialProvider;
    }

    Duration getBlockTimeout() {
        return Duration.ofSeconds(30L);
    }

    AtomicBoolean getIsInitialized() {
        return this.isInitialized;
    }
}

