/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.extensions.jdbc.postgresql;

import com.azure.identity.extensions.implementation.template.AzureAuthenticationTemplate;
import java.util.Properties;
import org.postgresql.plugin.AuthenticationPlugin;
import org.postgresql.plugin.AuthenticationRequestType;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class AzurePostgresqlAuthenticationPlugin
implements AuthenticationPlugin {
    private final AzureAuthenticationTemplate azureAuthenticationTemplate;

    public AzurePostgresqlAuthenticationPlugin(Properties properties) {
        this(new AzureAuthenticationTemplate(), properties);
    }

    AzurePostgresqlAuthenticationPlugin(AzureAuthenticationTemplate azureAuthenticationTemplate, Properties properties) {
        this.azureAuthenticationTemplate = azureAuthenticationTemplate;
        this.azureAuthenticationTemplate.init(properties);
    }

    public char[] getPassword(AuthenticationRequestType type) throws PSQLException {
        String password = this.azureAuthenticationTemplate.getTokenAsPassword();
        if (password != null) {
            return password.toCharArray();
        }
        throw new PSQLException("Unable to acquire access token", PSQLState.INVALID_PASSWORD);
    }

    AzureAuthenticationTemplate getAzureAuthenticationTemplate() {
        return this.azureAuthenticationTemplate;
    }
}

