/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.credential.TokenCredential;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.AzureCliCredential;
import com.azure.identity.AzureDeveloperCliCredential;
import com.azure.identity.AzurePowerShellCredential;
import com.azure.identity.CredentialBuilderBase;
import com.azure.identity.DefaultAzureCredential;
import com.azure.identity.EnvironmentCredential;
import com.azure.identity.IntelliJCredential;
import com.azure.identity.ManagedIdentityCredential;
import com.azure.identity.SharedTokenCacheCredential;
import com.azure.identity.WorkloadIdentityCredential;
import com.azure.identity.implementation.IdentityLogOptionsImpl;
import com.azure.identity.implementation.util.IdentityUtil;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;

public class DefaultAzureCredentialBuilder
extends CredentialBuilderBase<DefaultAzureCredentialBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(DefaultAzureCredentialBuilder.class);
    private String tenantId;
    private String managedIdentityClientId;
    private String workloadIdentityClientId;
    private String managedIdentityResourceId;
    private List<String> additionallyAllowedTenants = IdentityUtil.getAdditionalTenantsFromEnvironment(Configuration.getGlobalConfiguration().clone());

    public DefaultAzureCredentialBuilder() {
        this.identityClientOptions.setIdentityLogOptionsImpl(new IdentityLogOptionsImpl(true));
        this.identityClientOptions.setChained(true);
    }

    public DefaultAzureCredentialBuilder tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public DefaultAzureCredentialBuilder authorityHost(String authorityHost) {
        this.identityClientOptions.setAuthorityHost(authorityHost);
        return this;
    }

    public DefaultAzureCredentialBuilder intelliJKeePassDatabasePath(String databasePath) {
        if (CoreUtils.isNullOrEmpty((CharSequence)databasePath)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("The KeePass database path is either empty or not configured. Please configure it on the builder."));
        }
        this.identityClientOptions.setIntelliJKeePassDatabasePath(databasePath);
        return this;
    }

    public DefaultAzureCredentialBuilder managedIdentityClientId(String clientId) {
        this.managedIdentityClientId = clientId;
        return this;
    }

    public DefaultAzureCredentialBuilder workloadIdentityClientId(String clientId) {
        this.workloadIdentityClientId = clientId;
        return this;
    }

    public DefaultAzureCredentialBuilder managedIdentityResourceId(String resourceId) {
        this.managedIdentityResourceId = resourceId;
        return this;
    }

    public DefaultAzureCredentialBuilder executorService(ExecutorService executorService) {
        this.identityClientOptions.setExecutorService(executorService);
        return this;
    }

    public DefaultAzureCredentialBuilder additionallyAllowedTenants(String ... additionallyAllowedTenants) {
        this.additionallyAllowedTenants = IdentityUtil.resolveAdditionalTenants(Arrays.asList(additionallyAllowedTenants));
        return this;
    }

    public DefaultAzureCredentialBuilder additionallyAllowedTenants(List<String> additionallyAllowedTenants) {
        this.additionallyAllowedTenants = IdentityUtil.resolveAdditionalTenants(additionallyAllowedTenants);
        return this;
    }

    public DefaultAzureCredentialBuilder credentialProcessTimeout(Duration credentialProcessTimeout) {
        Objects.requireNonNull(credentialProcessTimeout);
        this.identityClientOptions.setCredentialProcessTimeout(credentialProcessTimeout);
        return this;
    }

    public DefaultAzureCredentialBuilder disableInstanceDiscovery() {
        this.identityClientOptions.disableInstanceDiscovery();
        return this;
    }

    public DefaultAzureCredential build() {
        this.loadFallbackValuesFromEnvironment();
        if (this.managedIdentityClientId != null && this.managedIdentityResourceId != null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Only one of managedIdentityResourceId and managedIdentityClientId can be specified."));
        }
        if (!CoreUtils.isNullOrEmpty(this.additionallyAllowedTenants)) {
            this.identityClientOptions.setAdditionallyAllowedTenants(this.additionallyAllowedTenants);
        }
        return new DefaultAzureCredential(this.getCredentialsChain());
    }

    private void loadFallbackValuesFromEnvironment() {
        Configuration configuration = this.identityClientOptions.getConfiguration() == null ? Configuration.getGlobalConfiguration().clone() : this.identityClientOptions.getConfiguration();
        this.tenantId = CoreUtils.isNullOrEmpty((CharSequence)this.tenantId) ? configuration.get("AZURE_TENANT_ID") : this.tenantId;
        this.managedIdentityClientId = CoreUtils.isNullOrEmpty((CharSequence)this.managedIdentityClientId) ? configuration.get("AZURE_CLIENT_ID") : this.managedIdentityClientId;
    }

    private ArrayList<TokenCredential> getCredentialsChain() {
        ArrayList<TokenCredential> output = new ArrayList<TokenCredential>(8);
        output.add(new EnvironmentCredential(this.identityClientOptions.clone()));
        output.add(this.getWorkloadIdentityCredential());
        output.add(new ManagedIdentityCredential(this.managedIdentityClientId, this.managedIdentityResourceId, this.identityClientOptions.clone()));
        output.add(new SharedTokenCacheCredential(null, "04b07795-8ddb-461a-bbee-02f9e1bf7b46", this.tenantId, this.identityClientOptions.clone()));
        output.add(new IntelliJCredential(this.tenantId, this.identityClientOptions.clone()));
        output.add(new AzureCliCredential(this.tenantId, this.identityClientOptions.clone()));
        output.add(new AzurePowerShellCredential(this.tenantId, this.identityClientOptions.clone()));
        output.add(new AzureDeveloperCliCredential(this.tenantId, this.identityClientOptions.clone()));
        return output;
    }

    private WorkloadIdentityCredential getWorkloadIdentityCredential() {
        String clientId;
        Configuration configuration = this.identityClientOptions.getConfiguration() == null ? Configuration.getGlobalConfiguration().clone() : this.identityClientOptions.getConfiguration();
        String azureAuthorityHost = configuration.get("AZURE_AUTHORITY_HOST");
        String string = clientId = CoreUtils.isNullOrEmpty((CharSequence)this.workloadIdentityClientId) ? this.managedIdentityClientId : this.workloadIdentityClientId;
        if (!CoreUtils.isNullOrEmpty((CharSequence)azureAuthorityHost)) {
            this.identityClientOptions.setAuthorityHost(azureAuthorityHost);
        }
        return new WorkloadIdentityCredential(this.tenantId, clientId, null, this.identityClientOptions.clone());
    }
}

