/*
 * Decompiled with CFR 0.152.
 */
package com.azure.json;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public class BasicJsonSerializable
implements JsonSerializable<BasicJsonSerializable> {
    private int anInt;
    private boolean aBoolean;
    private String aString;
    private Double aNullableDecimal;

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeIntField("int", this.anInt).writeBooleanField("boolean", this.aBoolean).writeStringField("string", this.aString).writeNumberField("decimal", (Number)this.aNullableDecimal).writeEndObject();
    }

    public static BasicJsonSerializable fromJson(JsonReader jsonReader) throws IOException {
        return (BasicJsonSerializable)jsonReader.readObject(reader -> {
            BasicJsonSerializable value = new BasicJsonSerializable();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("int".equals(fieldName)) {
                    value.anInt = reader.getInt();
                    continue;
                }
                if ("boolean".equals(fieldName)) {
                    value.aBoolean = reader.getBoolean();
                    continue;
                }
                if ("string".equals(fieldName)) {
                    value.aString = reader.getString();
                    continue;
                }
                if ("decimal".equals(fieldName)) {
                    value.aNullableDecimal = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                reader.skipChildren();
            }
            return value;
        });
    }
}

