/*
 * Decompiled with CFR 0.152.
 */
package com.azure.json;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public class FlattenedPropertiesJsonSerializable
implements JsonSerializable<FlattenedPropertiesJsonSerializable> {
    private final String aString;

    public FlattenedPropertiesJsonSerializable(String aString) {
        this.aString = aString;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.aString != null) {
            jsonWriter.writeStartObject("flattened").writeStringField("string", this.aString).writeEndObject();
        }
        return jsonWriter.writeEndObject();
    }

    public static FlattenedPropertiesJsonSerializable fromJson(JsonReader jsonReader) throws IOException {
        return (FlattenedPropertiesJsonSerializable)jsonReader.readObject(reader -> {
            String aString = null;
            boolean foundAString = false;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("flattened".equals(fieldName)) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("string".equals(fieldName)) {
                            aString = reader.getString();
                            foundAString = true;
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                reader.skipChildren();
            }
            if (foundAString) {
                return new FlattenedPropertiesJsonSerializable(aString);
            }
            throw new IllegalStateException("Missing required JSON properties. Required properties are 'flattened.string'.");
        });
    }
}

