/*
 * Decompiled with CFR 0.152.
 */
package com.azure.json.codesnippets;

import com.azure.json.JsonProviders;
import com.azure.json.JsonReader;
import com.azure.json.codesnippets.ComputerMemory;
import com.azure.json.codesnippets.ComputerProcessor;
import com.azure.json.codesnippets.VmStatistics;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;

public class ReadingJsonExamples {
    public ComputerMemory readJsonByteArray() throws IOException {
        byte[] json = "{\"memoryInBytes\":10000000000,\"clockSpeedInHertz\":4800000000,\"manufacturer\":\"Memory Corp\",\"errorCorrecting\":true}".getBytes(StandardCharsets.UTF_8);
        try (JsonReader jsonReader = JsonProviders.createReader((byte[])json);){
            ComputerMemory computerMemory = ComputerMemory.fromJson(jsonReader);
            return computerMemory;
        }
    }

    public ComputerProcessor readJsonString() throws IOException {
        String json = "{\"cores\":16,\"threads\":32,\"manufacturer\":\"Processor Corp\",\"clockSpeedInHertz\":5000000000,\"releaseDate\":null}";
        try (JsonReader jsonReader = JsonProviders.createReader((String)json);){
            ComputerProcessor computerProcessor = ComputerProcessor.fromJson(jsonReader);
            return computerProcessor;
        }
    }

    public VmStatistics readJsonInputStream() throws IOException {
        ByteArrayInputStream json = new ByteArrayInputStream("{\"VMSize\":\"large\",\"Processor\":{\"cores\":8,\"threads\"16\",\"manufacturer\":\"Processor Corp\",\"clockSpeedInHertz\":4000000000,\"releaseDate\":\"2023-01-01\"},\"Memory\":{\"memoryInBytes\":10000000000,\"clockSpeedInHertz\":4800000000,\"manufacturer\":\"Memory Corp\",\"errorCorrecting\":true},\"AcceleratedNetwork\":true,\"CloudProvider\":\"Azure\",\"Available\":true}".getBytes(StandardCharsets.UTF_8));
        try (JsonReader jsonReader = JsonProviders.createReader((InputStream)json);){
            VmStatistics vmStatistics = VmStatistics.fromJson(jsonReader);
            return vmStatistics;
        }
    }

    public VmStatistics readJsonReader() throws IOException {
        StringReader json = new StringReader("{\"VMSize\":\"large\",\"Processor\":{\"cores\":8,\"threads\"16\",\"manufacturer\":\"Processor Corp\",\"clockSpeedInHertz\":4000000000,\"releaseDate\":\"2023-01-01\"},\"Memory\":{\"memoryInBytes\":10000000000,\"clockSpeedInHertz\":4800000000,\"manufacturer\":\"Memory Corp\",\"errorCorrecting\":true},\"AcceleratedNetwork\":true,\"CloudProvider\":\"Azure\",\"Available\":true}");
        try (JsonReader jsonReader = JsonProviders.createReader((Reader)json);){
            VmStatistics vmStatistics = VmStatistics.fromJson(jsonReader);
            return vmStatistics;
        }
    }
}

