/*
 * Decompiled with CFR 0.152.
 */
package com.azure.json.codesnippets;

import com.azure.json.JsonProviders;
import com.azure.json.JsonWriter;
import com.azure.json.codesnippets.ComputerMemory;
import com.azure.json.codesnippets.ComputerProcessor;
import com.azure.json.codesnippets.VmStatistics;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.time.OffsetDateTime;
import java.util.LinkedHashMap;

public class WritingJsonExamples {
    public void writeJsonOutputStream() throws IOException {
        LinkedHashMap<String, Object> additionalVmProperties = new LinkedHashMap<String, Object>();
        additionalVmProperties.put("CloudProvider", "Azure");
        additionalVmProperties.put("Available", true);
        VmStatistics vmStatistics = new VmStatistics("large", new ComputerProcessor(8, 16, "Processor Corp", 4.0E9, OffsetDateTime.parse("2023-01-01")), new ComputerMemory().setMemoryInBytes(10000000000L).setClockSpeedInHertz(4.8E9).setManufacturer("Memory Corp").setErrorCorrecting(true), true).setAdditionalProperties(additionalVmProperties);
        ByteArrayOutputStream json = new ByteArrayOutputStream();
        try (JsonWriter jsonWriter = JsonProviders.createWriter((OutputStream)json);){
            vmStatistics.toJson(jsonWriter);
        }
        System.out.println(json);
    }

    public void writeJsonWriter() throws IOException {
        LinkedHashMap<String, Object> additionalVmProperties = new LinkedHashMap<String, Object>();
        additionalVmProperties.put("CloudProvider", "Azure");
        additionalVmProperties.put("Available", true);
        VmStatistics vmStatistics = new VmStatistics("large", new ComputerProcessor(8, 16, "Processor Corp", 4.0E9, OffsetDateTime.parse("2023-01-01")), new ComputerMemory().setMemoryInBytes(10000000000L).setClockSpeedInHertz(4.8E9).setManufacturer("Memory Corp").setErrorCorrecting(true), true).setAdditionalProperties(additionalVmProperties);
        StringWriter json = new StringWriter();
        try (JsonWriter jsonWriter = JsonProviders.createWriter((Writer)json);){
            vmStatistics.toJson(jsonWriter);
        }
        System.out.println(json);
    }
}

