/*
 * Decompiled with CFR 0.152.
 */
package com.azure.json.contract;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;

public final class SimpleSerializable
implements JsonSerializable<SimpleSerializable> {
    private final boolean aBoolean;
    private final int anInt;
    private final double aDecimal;
    private final String aString;

    public SimpleSerializable(boolean aBoolean, int anInt, double aDecimal, String aString) {
        this.aBoolean = aBoolean;
        this.anInt = anInt;
        this.aDecimal = aDecimal;
        this.aString = aString;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("boolean", this.aBoolean);
        jsonWriter.writeIntField("int", this.anInt);
        jsonWriter.writeDoubleField("decimal", this.aDecimal);
        jsonWriter.writeStringField("string", this.aString);
        return jsonWriter.writeEndObject();
    }

    public static SimpleSerializable fromJson(JsonReader jsonReader) throws IOException {
        return (SimpleSerializable)jsonReader.readObject(reader -> {
            boolean aBoolean = false;
            boolean foundABoolean = false;
            double aDecimal = 0.0;
            boolean foundADecimal = false;
            int anInt = 0;
            boolean foundAnInt = false;
            String aString = null;
            boolean foundAString = false;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("boolean".equals(fieldName)) {
                    aBoolean = reader.getBoolean();
                    foundABoolean = true;
                    continue;
                }
                if ("decimal".equals(fieldName)) {
                    aDecimal = reader.getDouble();
                    foundADecimal = true;
                    continue;
                }
                if ("int".equals(fieldName)) {
                    anInt = reader.getInt();
                    foundAnInt = true;
                    continue;
                }
                if ("string".equals(fieldName)) {
                    aString = reader.getString();
                    foundAString = true;
                    continue;
                }
                reader.skipChildren();
            }
            if (foundABoolean && foundADecimal && foundAnInt && foundAString) {
                return new SimpleSerializable(aBoolean, anInt, aDecimal, aString);
            }
            throw new IllegalStateException("Missing required properties.");
        });
    }

    public boolean isABoolean() {
        return this.aBoolean;
    }

    public int getAnInt() {
        return this.anInt;
    }

    public double getADecimal() {
        return this.aDecimal;
    }

    public String getAString() {
        return this.aString;
    }

    public int hashCode() {
        return Objects.hash(this.aBoolean, this.anInt, this.aDecimal, this.aString);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SimpleSerializable)) {
            return false;
        }
        SimpleSerializable other = (SimpleSerializable)obj;
        return this.aBoolean == other.aBoolean && this.anInt == other.anInt && this.aDecimal == other.aDecimal && Objects.equals(this.aString, other.aString);
    }
}

