/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs.implementation;

import com.azure.core.amqp.models.AmqpAddress;
import com.azure.core.amqp.models.AmqpAnnotatedMessage;
import com.azure.core.amqp.models.AmqpMessageBody;
import com.azure.core.amqp.models.AmqpMessageHeader;
import com.azure.core.amqp.models.AmqpMessageId;
import com.azure.core.amqp.models.AmqpMessageProperties;
import com.azure.core.util.logging.ClientLogger;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.amqp.messaging.Footer;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.message.Message;

public final class MessageUtils {
    private static final ClientLogger LOGGER = new ClientLogger(MessageUtils.class);
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    public static Message toProtonJMessage(AmqpAnnotatedMessage message) {
        Map<Symbol, Object> deliveryAnnotations;
        Map<Symbol, Object> messageAnnotations;
        AmqpMessageHeader header;
        AmqpAddress replyTo;
        Objects.requireNonNull(message, "'message' to serialize cannot be null.");
        Message protonJMessage = Proton.message();
        AmqpMessageBody body = message.getBody();
        switch (body.getBodyType()) {
            case DATA: {
                protonJMessage.setBody((Section)new Data(new Binary(body.getFirstData())));
                break;
            }
            default: {
                throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("bodyType [" + body.getBodyType() + "] is not supported yet."));
            }
        }
        AmqpMessageProperties properties = message.getProperties();
        if (properties.getMessageId() != null) {
            protonJMessage.setMessageId((Object)properties.getMessageId().toString());
        }
        if (properties.getContentType() != null) {
            protonJMessage.setContentType(properties.getContentType());
        }
        if (properties.getCorrelationId() != null) {
            protonJMessage.setCorrelationId((Object)properties.getCorrelationId().toString());
        }
        if (properties.getSubject() != null) {
            protonJMessage.setSubject(properties.getSubject());
        }
        if ((replyTo = properties.getReplyTo()) != null) {
            protonJMessage.setReplyTo(replyTo.toString());
        }
        if (properties.getReplyToGroupId() != null) {
            protonJMessage.setReplyToGroupId(properties.getReplyToGroupId());
        }
        if (properties.getGroupId() != null) {
            protonJMessage.setGroupId(properties.getGroupId());
        }
        if (properties.getContentEncoding() != null) {
            protonJMessage.setContentEncoding(properties.getContentEncoding());
        }
        if (properties.getGroupSequence() != null) {
            protonJMessage.setGroupSequence(properties.getGroupSequence().longValue());
        }
        if (properties.getTo() != null) {
            if (protonJMessage.getProperties() == null) {
                protonJMessage.setProperties(new Properties());
            }
            protonJMessage.getProperties().setTo(properties.getTo().toString());
        }
        if (properties.getUserId() != null && properties.getUserId().length > 0) {
            if (protonJMessage.getProperties() == null) {
                protonJMessage.setProperties(new Properties());
            }
            protonJMessage.getProperties().setUserId(new Binary(properties.getUserId()));
        }
        if (properties.getAbsoluteExpiryTime() != null) {
            if (protonJMessage.getProperties() == null) {
                protonJMessage.setProperties(new Properties());
            }
            protonJMessage.getProperties().setAbsoluteExpiryTime(Date.from(properties.getAbsoluteExpiryTime().toInstant()));
        }
        if (properties.getCreationTime() != null) {
            if (protonJMessage.getProperties() == null) {
                protonJMessage.setProperties(new Properties());
            }
            protonJMessage.getProperties().setCreationTime(Date.from(properties.getCreationTime().toInstant()));
        }
        if ((header = message.getHeader()).getTimeToLive() != null) {
            protonJMessage.setTtl(header.getTimeToLive().toMillis());
        }
        if (header.getDeliveryCount() != null) {
            protonJMessage.setDeliveryCount(header.getDeliveryCount().longValue());
        }
        if (header.getPriority() != null) {
            protonJMessage.setPriority(header.getPriority().shortValue());
        }
        if (header.isDurable() != null) {
            protonJMessage.setDurable(header.isDurable().booleanValue());
        }
        if (header.isFirstAcquirer() != null) {
            protonJMessage.setFirstAcquirer(header.isFirstAcquirer().booleanValue());
        }
        if (header.getTimeToLive() != null) {
            protonJMessage.setTtl(header.getTimeToLive().toMillis());
        }
        if (!message.getFooter().isEmpty()) {
            protonJMessage.setFooter(new Footer(message.getFooter()));
        }
        if (!(messageAnnotations = MessageUtils.convert(message.getMessageAnnotations())).isEmpty()) {
            protonJMessage.setMessageAnnotations(new MessageAnnotations(messageAnnotations));
        }
        if (!(deliveryAnnotations = MessageUtils.convert(message.getDeliveryAnnotations())).isEmpty()) {
            protonJMessage.setDeliveryAnnotations(new DeliveryAnnotations(deliveryAnnotations));
        }
        if (!message.getApplicationProperties().isEmpty()) {
            protonJMessage.setApplicationProperties(new ApplicationProperties(message.getApplicationProperties()));
        }
        return protonJMessage;
    }

    public static AmqpAnnotatedMessage toAmqpAnnotatedMessage(Message message) {
        MessageAnnotations messageAnnotations;
        DeliveryAnnotations deliveryAnnotations;
        Footer footer;
        byte[] bytes;
        Objects.requireNonNull(message, "'message' cannot be null");
        Section body = message.getBody();
        if (body != null) {
            if (body instanceof Data) {
                Binary messageData = ((Data)body).getValue();
                if (messageData == null) {
                    LOGGER.verbose("Binary data message is null.");
                    bytes = EMPTY_BYTE_ARRAY;
                } else {
                    bytes = messageData.getArray();
                }
            } else {
                LOGGER.warning("Message not of type Data. Actual: {}", new Object[]{body.getType()});
                bytes = EMPTY_BYTE_ARRAY;
            }
        } else {
            LOGGER.warning("Message does not have a body.");
            bytes = EMPTY_BYTE_ARRAY;
        }
        AmqpAnnotatedMessage response = new AmqpAnnotatedMessage(AmqpMessageBody.fromData((byte[])bytes));
        ApplicationProperties applicationProperties = message.getApplicationProperties();
        if (applicationProperties != null) {
            Map propertiesValue = applicationProperties.getValue();
            response.getApplicationProperties().putAll(propertiesValue);
        }
        AmqpMessageHeader responseHeader = response.getHeader();
        responseHeader.setTimeToLive(Duration.ofMillis(message.getTtl()));
        responseHeader.setDeliveryCount(Long.valueOf(message.getDeliveryCount()));
        responseHeader.setPriority(Short.valueOf(message.getPriority()));
        if (message.getHeader() != null) {
            responseHeader.setDurable(message.getHeader().getDurable());
            responseHeader.setFirstAcquirer(message.getHeader().getFirstAcquirer());
        }
        if ((footer = message.getFooter()) != null && footer.getValue() != null) {
            Map footerValue = footer.getValue();
            MessageUtils.setValues(footerValue, response.getFooter());
        }
        if ((deliveryAnnotations = message.getDeliveryAnnotations()) != null) {
            MessageUtils.setValues(deliveryAnnotations.getValue(), response.getDeliveryAnnotations());
        }
        if ((messageAnnotations = message.getMessageAnnotations()) != null) {
            MessageUtils.setValues(messageAnnotations.getValue(), response.getMessageAnnotations());
        }
        AmqpMessageProperties responseProperties = response.getProperties();
        Properties protonJProperties = message.getProperties();
        if (protonJProperties != null) {
            String to;
            String replyTo;
            Object messageId;
            Object correlationId;
            if (protonJProperties.getAbsoluteExpiryTime() != null) {
                responseProperties.setAbsoluteExpiryTime(protonJProperties.getAbsoluteExpiryTime().toInstant().atOffset(ZoneOffset.UTC));
            }
            if (protonJProperties.getContentType() != null) {
                responseProperties.setContentType(protonJProperties.getContentType().toString());
            }
            if (protonJProperties.getContentEncoding() != null) {
                responseProperties.setContentEncoding(protonJProperties.getContentEncoding().toString());
            }
            if ((correlationId = message.getCorrelationId()) != null) {
                responseProperties.setCorrelationId(new AmqpMessageId(correlationId.toString()));
            }
            if (protonJProperties.getCreationTime() != null) {
                responseProperties.setCreationTime(protonJProperties.getCreationTime().toInstant().atOffset(ZoneOffset.UTC));
            }
            if (protonJProperties.getGroupId() != null) {
                responseProperties.setGroupId(protonJProperties.getGroupId());
            }
            if (protonJProperties.getGroupSequence() != null) {
                responseProperties.setGroupSequence(Long.valueOf(protonJProperties.getGroupSequence().longValue()));
            }
            if ((messageId = message.getMessageId()) != null) {
                responseProperties.setMessageId(new AmqpMessageId(messageId.toString()));
            }
            if ((replyTo = protonJProperties.getReplyTo()) != null) {
                responseProperties.setReplyTo(new AmqpAddress(replyTo));
            }
            if (protonJProperties.getReplyToGroupId() != null) {
                responseProperties.setReplyToGroupId(protonJProperties.getReplyToGroupId());
            }
            if (protonJProperties.getSubject() != null) {
                responseProperties.setSubject(protonJProperties.getSubject());
            }
            if ((to = protonJProperties.getTo()) != null) {
                responseProperties.setTo(new AmqpAddress(to));
            }
            if (protonJProperties.getUserId() != null) {
                responseProperties.setUserId(protonJProperties.getUserId().getArray());
            }
        }
        return response;
    }

    public static Map<Symbol, Object> convert(Map<String, Object> sourceMap) {
        if (sourceMap == null) {
            return null;
        }
        return sourceMap.entrySet().stream().collect(HashMap::new, (existing, entry) -> {
            if (entry.getValue() instanceof Instant) {
                long epochMilli = ((Instant)entry.getValue()).toEpochMilli();
                existing.put(Symbol.valueOf((String)((String)entry.getKey())), new Date(epochMilli));
            } else {
                existing.put(Symbol.valueOf((String)((String)entry.getKey())), entry.getValue());
            }
        }, HashMap::putAll);
    }

    public static <T> Instant getEnqueuedTime(Map<T, Object> messageAnnotations, T enqueuedTimeKey) {
        Object enqueuedTimeObject = messageAnnotations.get(enqueuedTimeKey);
        if (enqueuedTimeObject instanceof Date) {
            return ((Date)enqueuedTimeObject).toInstant();
        }
        if (enqueuedTimeObject instanceof Instant) {
            return (Instant)enqueuedTimeObject;
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException(new IllegalStateException(String.format(Locale.US, "enqueuedTime is not a known type. Value: %s. Type: %s", enqueuedTimeObject, enqueuedTimeObject.getClass()))));
    }

    private static void setValues(Map<Symbol, Object> sourceMap, Map<String, Object> targetMap) {
        if (sourceMap == null) {
            return;
        }
        for (Map.Entry<Symbol, Object> entry : sourceMap.entrySet()) {
            targetMap.put(entry.getKey().toString(), entry.getValue());
        }
    }

    private MessageUtils() {
    }
}

