/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter;

import com.azure.core.util.logging.ClientLogger;
import com.azure.monitor.opentelemetry.exporter.implementation.MetricDataMapper;
import com.azure.monitor.opentelemetry.exporter.implementation.logging.OperationLogger;
import com.azure.monitor.opentelemetry.exporter.implementation.models.TelemetryItem;
import com.azure.monitor.opentelemetry.exporter.implementation.pipeline.TelemetryItemExporter;
import com.azure.monitor.opentelemetry.exporter.implementation.utils.AzureMonitorMsgId;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.AggregationTemporalitySelector;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;

class AzureMonitorMetricExporter
implements MetricExporter {
    private static final ClientLogger LOGGER = new ClientLogger(AzureMonitorMetricExporter.class);
    private static final OperationLogger OPERATION_LOGGER = new OperationLogger(AzureMonitorMetricExporter.class, "Exporting metric");
    private final AtomicBoolean stopped = new AtomicBoolean();
    private final MetricDataMapper mapper;
    private final TelemetryItemExporter telemetryItemExporter;

    AzureMonitorMetricExporter(MetricDataMapper mapper, TelemetryItemExporter telemetryItemExporter) {
        this.mapper = mapper;
        this.telemetryItemExporter = telemetryItemExporter;
    }

    public AggregationTemporality getAggregationTemporality(InstrumentType instrumentType) {
        return AggregationTemporalitySelector.deltaPreferred().getAggregationTemporality(instrumentType);
    }

    public CompletableResultCode export(Collection<MetricData> metrics) {
        if (this.stopped.get()) {
            return CompletableResultCode.ofFailure();
        }
        ArrayList<TelemetryItem> telemetryItems = new ArrayList<TelemetryItem>();
        for (MetricData metricData : metrics) {
            LOGGER.verbose("exporting metric: {}", new Object[]{metricData});
            try {
                this.mapper.map(metricData, telemetryItems::add);
                OPERATION_LOGGER.recordSuccess();
            }
            catch (Throwable t) {
                OPERATION_LOGGER.recordFailure(t.getMessage(), t, AzureMonitorMsgId.EXPORTER_MAPPING_ERROR);
                return CompletableResultCode.ofFailure();
            }
        }
        return this.telemetryItemExporter.send(telemetryItems);
    }

    public CompletableResultCode flush() {
        return this.telemetryItemExporter.flush();
    }

    public CompletableResultCode shutdown() {
        this.stopped.set(true);
        return this.telemetryItemExporter.shutdown();
    }
}

