/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.builders;

import com.azure.monitor.opentelemetry.exporter.implementation.builders.AbstractTelemetryBuilder;
import com.azure.monitor.opentelemetry.exporter.implementation.builders.ExceptionDetailBuilder;
import com.azure.monitor.opentelemetry.exporter.implementation.builders.TelemetryTruncation;
import com.azure.monitor.opentelemetry.exporter.implementation.models.SeverityLevel;
import com.azure.monitor.opentelemetry.exporter.implementation.models.TelemetryExceptionData;
import com.azure.monitor.opentelemetry.exporter.implementation.models.TelemetryExceptionDetails;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import reactor.util.annotation.Nullable;

public final class ExceptionTelemetryBuilder
extends AbstractTelemetryBuilder {
    private static final int MAX_PROBLEM_ID_LENGTH = 1024;
    private final TelemetryExceptionData data;

    public static ExceptionTelemetryBuilder create() {
        return new ExceptionTelemetryBuilder(new TelemetryExceptionData());
    }

    private ExceptionTelemetryBuilder(TelemetryExceptionData data) {
        super(data, "Exception", "ExceptionData");
        this.data = data;
    }

    public void setExceptions(List<ExceptionDetailBuilder> builders) {
        ArrayList<TelemetryExceptionDetails> details = new ArrayList<TelemetryExceptionDetails>();
        for (ExceptionDetailBuilder builder : builders) {
            details.add(builder.build());
        }
        this.data.setExceptions(details);
    }

    public void setSeverityLevel(SeverityLevel severityLevel) {
        this.data.setSeverityLevel(severityLevel);
    }

    public void setProblemId(String problemId) {
        this.data.setProblemId(TelemetryTruncation.truncateTelemetry(problemId, 1024, "Exception.problemId"));
    }

    public void addMeasurement(@Nullable String key, Double value) {
        if (key == null || key.isEmpty() || key.length() > 150) {
            return;
        }
        Map<String, Double> measurements = this.data.getMeasurements();
        if (measurements == null) {
            measurements = new HashMap<String, Double>();
            this.data.setMeasurements(measurements);
        }
        measurements.put(key, value);
    }

    @Override
    protected Map<String, String> getProperties() {
        Map<String, String> properties = this.data.getProperties();
        if (properties == null) {
            properties = new HashMap<String, String>();
            this.data.setProperties(properties);
        }
        return properties;
    }
}

