/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.pipeline;

import com.azure.monitor.opentelemetry.exporter.implementation.pipeline.TelemetryPipelineRequest;
import com.azure.monitor.opentelemetry.exporter.implementation.pipeline.TelemetryPipelineResponse;
import io.opentelemetry.sdk.common.CompletableResultCode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public interface TelemetryPipelineListener {
    public void onResponse(TelemetryPipelineRequest var1, TelemetryPipelineResponse var2);

    public void onException(TelemetryPipelineRequest var1, String var2, Throwable var3);

    public CompletableResultCode shutdown();

    public static TelemetryPipelineListener composite(TelemetryPipelineListener ... delegates) {
        return new CompositeTelemetryPipelineListener(Arrays.asList(delegates));
    }

    public static TelemetryPipelineListener noop() {
        return NoopTelemetryPipelineListener.INSTANCE;
    }

    public static class CompositeTelemetryPipelineListener
    implements TelemetryPipelineListener {
        private final List<TelemetryPipelineListener> delegates;

        public CompositeTelemetryPipelineListener(List<TelemetryPipelineListener> delegates) {
            this.delegates = delegates;
        }

        @Override
        public void onResponse(TelemetryPipelineRequest request, TelemetryPipelineResponse response) {
            for (TelemetryPipelineListener delegate : this.delegates) {
                delegate.onResponse(request, response);
            }
        }

        @Override
        public void onException(TelemetryPipelineRequest request, String errorMessage, Throwable throwable) {
            for (TelemetryPipelineListener delegate : this.delegates) {
                delegate.onException(request, errorMessage, throwable);
            }
        }

        @Override
        public CompletableResultCode shutdown() {
            ArrayList<CompletableResultCode> results = new ArrayList<CompletableResultCode>();
            for (TelemetryPipelineListener delegate : this.delegates) {
                results.add(delegate.shutdown());
            }
            return CompletableResultCode.ofAll(results);
        }
    }

    public static class NoopTelemetryPipelineListener
    implements TelemetryPipelineListener {
        static final TelemetryPipelineListener INSTANCE = new NoopTelemetryPipelineListener();

        @Override
        public void onResponse(TelemetryPipelineRequest request, TelemetryPipelineResponse response) {
        }

        @Override
        public void onException(TelemetryPipelineRequest request, String errorMessage, Throwable throwable) {
        }

        @Override
        public CompletableResultCode shutdown() {
            return CompletableResultCode.ofSuccess();
        }
    }
}

