/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.statsbeat;

import com.azure.monitor.opentelemetry.exporter.implementation.builders.StatsbeatTelemetryBuilder;
import com.azure.monitor.opentelemetry.exporter.implementation.configuration.StatsbeatConnectionString;
import com.azure.monitor.opentelemetry.exporter.implementation.pipeline.TelemetryItemExporter;
import com.azure.monitor.opentelemetry.exporter.implementation.statsbeat.CustomDimensions;

abstract class BaseStatsbeat {
    private final CustomDimensions customDimensions;
    protected StatsbeatConnectionString connectionString;
    protected String instrumentationKey;

    protected BaseStatsbeat(CustomDimensions customDimensions) {
        this.customDimensions = customDimensions;
    }

    protected abstract void send(TelemetryItemExporter var1);

    protected StatsbeatTelemetryBuilder createStatsbeatTelemetry(String name, double value) {
        StatsbeatTelemetryBuilder telemetryBuilder = StatsbeatTelemetryBuilder.create(name, value);
        if (this.connectionString != null) {
            telemetryBuilder.setConnectionString(this.connectionString);
        }
        this.customDimensions.populateProperties(telemetryBuilder, this.instrumentationKey);
        return telemetryBuilder;
    }

    void setConnectionString(StatsbeatConnectionString connectionString) {
        this.connectionString = connectionString;
    }

    String getInstrumentationKey() {
        return this.instrumentationKey;
    }

    void setInstrumentationKey(String instrumentationKey) {
        this.instrumentationKey = instrumentationKey;
    }
}

