/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.statsbeat;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public enum Feature {
    JAVA_VENDOR_ORACLE(0),
    JAVA_VENDOR_ZULU(1),
    JAVA_VENDOR_MICROSOFT(2),
    JAVA_VENDOR_ADOPT_OPENJDK(3),
    JAVA_VENDOR_REDHAT(4),
    JAVA_VENDOR_OTHER(5),
    AAD(6),
    CASSANDRA_DISABLED(7),
    JDBC_DISABLED(8),
    JMS_DISABLED(9),
    KAFKA_DISABLED(10),
    MICROMETER_DISABLED(11),
    MONGO_DISABLED(12),
    REDIS_DISABLED(13),
    SPRING_SCHEDULING_DISABLED(14),
    AZURE_SDK_DISABLED(15),
    RABBITMQ_DISABLED(16),
    SPRING_INTEGRATION_DISABLED(17),
    LEGACY_PROPAGATION_ENABLED(18),
    GRIZZLY_ENABLED(19),
    STATSBEAT_DISABLED(20),
    QUARTZ_DISABLED(21),
    APACHE_CAMEL_DISABLED(22),
    AKKA_DISABLED(23),
    PROPAGATION_DISABLED(24),
    PLAY_DISABLED(25),
    CAPTURE_HTTP_SERVER_4XX_AS_SUCCESS(26),
    CAPTURE_HTTP_SERVER_HEADERS(27),
    CAPTURE_HTTP_CLIENT_HEADERS(28),
    VERTX_DISABLED(29),
    CUSTOM_DIMENSIONS_ENABLED(30),
    JAXRS_ANNOTATIONS_DISABLED(31),
    LOGGING_LEVEL_CUSTOM_PROPERTY_ENABLED(32),
    TELEMETRY_PROCESSOR_ENABLED(33),
    SDK_2X_BRIDGE_VIA_3X_AGENT(34),
    PROFILER_ENABLED(35),
    BROWSER_SDK_LOADER(36),
    SAMPLING(37),
    PREVIEW_CAPTURE_CONTROLLER_SPANS(38),
    PREVIEW_LIVE_METRICS(39),
    PREVIEW_LEGACY_REQUEST_ID_PROPAGATION(40),
    PREVIEW_DISABLE_PROPAGATION(41),
    PREVIEW_CAPTURE_LOGGING_LEVEL_AS_CUSTOM_DIMENSION(42),
    PREVIEW_CAPTURE_LOGBACK_CODE_ATTRIBUTES(43),
    PREVIEW_CAPTURE_LOGBACK_MARKER(44),
    PREVIEW_CAPTURE_LOG4J_MARKER(45),
    PREVIEW_INHERITED_ATTRIBUTES(46),
    PREVIEW_GC_EVENTS(47),
    PREVIEW_CONNECTION_STRING_OVERRIDES(48),
    PREVIEW_ROLE_NAME_OVERRIDES(49),
    PREVIEW_INSTRUMENTATION_OVERRIDES(50),
    PREVIEW_GENERAL_EXPORT_QUEUE_CAPACITY(51),
    PREVIEW_METRICS_EXPORT_QUEUE_CAPACITY(52),
    PREVIEW_DISK_PERSISTENCE_MAX_SIZE_MB(53),
    PREVIEW_DONT_USE_NORMALIZED(54),
    PREVIEW_CUSTOM_INSTRUMENTATION(55),
    PREVIEW_ADDITIONAL_PROPAGATORS(56),
    GRAAL_VM_NATIVE(57),
    PEKKO_DISABLED(58);

    private static final Map<String, Feature> javaVendorFeatureMap;
    private final int bitmapIndex;

    private Feature(int bitmapIndex) {
        this.bitmapIndex = bitmapIndex;
    }

    static Feature fromJavaVendor(String javaVendor) {
        Feature feature = javaVendorFeatureMap.get(javaVendor);
        return feature != null ? feature : JAVA_VENDOR_OTHER;
    }

    static long encode(Set<Feature> features) {
        BitSet bitSet = new BitSet(64);
        for (Feature feature : features) {
            bitSet.set(feature.bitmapIndex);
        }
        long[] longArray = bitSet.toLongArray();
        if (longArray.length > 0) {
            return longArray[0];
        }
        return 0L;
    }

    int getBitmapIndex() {
        return this.bitmapIndex;
    }

    static {
        javaVendorFeatureMap = new HashMap<String, Feature>();
        javaVendorFeatureMap.put("Oracle Corporation", JAVA_VENDOR_ORACLE);
        javaVendorFeatureMap.put("Azul Systems, Inc.", JAVA_VENDOR_MICROSOFT);
        javaVendorFeatureMap.put("Microsoft", JAVA_VENDOR_MICROSOFT);
        javaVendorFeatureMap.put("AdoptOpenJDK", JAVA_VENDOR_ADOPT_OPENJDK);
        javaVendorFeatureMap.put("Red Hat, Inc.", JAVA_VENDOR_REDHAT);
    }
}

