/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.utils;

import com.azure.monitor.opentelemetry.exporter.implementation.utils.AzureMonitorMsgId;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import reactor.util.annotation.Nullable;

public final class CpuPerformanceCounterCalculator {
    private static final Logger logger = LoggerFactory.getLogger(CpuPerformanceCounterCalculator.class);
    private static final RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
    private long prevUpTime;
    private long prevProcessCpuTime;
    private ObjectName osBean;

    @Nullable
    public Double getCpuPercentage() {
        try {
            long upTime = runtimeMxBean.getUptime();
            long processCpuTime = this.getProcessCpuTime();
            if (this.prevUpTime > 0L && upTime > this.prevUpTime) {
                long elapsedCpu = processCpuTime - this.prevProcessCpuTime;
                long elapsedTime = upTime - this.prevUpTime;
                this.prevUpTime = upTime;
                this.prevProcessCpuTime = processCpuTime;
                return (double)elapsedCpu / ((double)elapsedTime * 10000.0);
            }
            this.prevUpTime = upTime;
            this.prevProcessCpuTime = processCpuTime;
            return null;
        }
        catch (Exception e) {
            try (MDC.MDCCloseable ignored = AzureMonitorMsgId.CPU_METRIC_ERROR.makeActive();){
                logger.error("Error in getProcessCPUUsage");
            }
            logger.trace("Error in getProcessCPUUsage", (Throwable)e);
            return null;
        }
    }

    private long getProcessCpuTime() throws Exception {
        MBeanServer bsvr = ManagementFactory.getPlatformMBeanServer();
        if (this.osBean == null) {
            this.osBean = ObjectName.getInstance("java.lang:type=OperatingSystem");
        }
        return (Long)bsvr.getAttribute(this.osBean, "ProcessCpuTime");
    }
}

