/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.IndexerExecutionStatus;
import com.azure.search.documents.indexes.models.SearchIndexerError;
import com.azure.search.documents.indexes.models.SearchIndexerWarning;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;

public final class IndexerExecutionResult
implements JsonSerializable<IndexerExecutionResult> {
    private final IndexerExecutionStatus status;
    private String errorMessage;
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private final List<SearchIndexerError> errors;
    private final List<SearchIndexerWarning> warnings;
    private final int itemCount;
    private final int failedItemCount;
    private String initialTrackingState;
    private String finalTrackingState;

    public IndexerExecutionResult(IndexerExecutionStatus status, List<SearchIndexerError> errors, List<SearchIndexerWarning> warnings, int itemCount, int failedItemCount) {
        this.status = status;
        this.errors = errors;
        this.warnings = warnings;
        this.itemCount = itemCount;
        this.failedItemCount = failedItemCount;
    }

    public IndexerExecutionStatus getStatus() {
        return this.status;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public OffsetDateTime getEndTime() {
        return this.endTime;
    }

    public List<SearchIndexerError> getErrors() {
        return this.errors;
    }

    public List<SearchIndexerWarning> getWarnings() {
        return this.warnings;
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public int getFailedItemCount() {
        return this.failedItemCount;
    }

    public String getInitialTrackingState() {
        return this.initialTrackingState;
    }

    public String getFinalTrackingState() {
        return this.finalTrackingState;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static IndexerExecutionResult fromJson(JsonReader jsonReader) throws IOException {
        return (IndexerExecutionResult)jsonReader.readObject(reader -> {
            boolean statusFound = false;
            IndexerExecutionStatus status = null;
            boolean errorsFound = false;
            List errors = null;
            boolean warningsFound = false;
            List warnings = null;
            boolean itemCountFound = false;
            int itemCount = 0;
            boolean failedItemCountFound = false;
            int failedItemCount = 0;
            String errorMessage = null;
            OffsetDateTime startTime = null;
            OffsetDateTime endTime = null;
            String initialTrackingState = null;
            String finalTrackingState = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    status = IndexerExecutionStatus.fromString(reader.getString());
                    statusFound = true;
                    continue;
                }
                if ("errors".equals(fieldName)) {
                    errors = reader.readArray(reader1 -> SearchIndexerError.fromJson(reader1));
                    errorsFound = true;
                    continue;
                }
                if ("warnings".equals(fieldName)) {
                    warnings = reader.readArray(reader1 -> SearchIndexerWarning.fromJson(reader1));
                    warningsFound = true;
                    continue;
                }
                if ("itemsProcessed".equals(fieldName)) {
                    itemCount = reader.getInt();
                    itemCountFound = true;
                    continue;
                }
                if ("itemsFailed".equals(fieldName)) {
                    failedItemCount = reader.getInt();
                    failedItemCountFound = true;
                    continue;
                }
                if ("errorMessage".equals(fieldName)) {
                    errorMessage = reader.getString();
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("initialTrackingState".equals(fieldName)) {
                    initialTrackingState = reader.getString();
                    continue;
                }
                if ("finalTrackingState".equals(fieldName)) {
                    finalTrackingState = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (statusFound && errorsFound && warningsFound && itemCountFound && failedItemCountFound) {
                IndexerExecutionResult deserializedIndexerExecutionResult = new IndexerExecutionResult(status, errors, warnings, itemCount, failedItemCount);
                deserializedIndexerExecutionResult.errorMessage = errorMessage;
                deserializedIndexerExecutionResult.startTime = startTime;
                deserializedIndexerExecutionResult.endTime = endTime;
                deserializedIndexerExecutionResult.initialTrackingState = initialTrackingState;
                deserializedIndexerExecutionResult.finalTrackingState = finalTrackingState;
                return deserializedIndexerExecutionResult;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!statusFound) {
                missingProperties.add("status");
            }
            if (!errorsFound) {
                missingProperties.add("errors");
            }
            if (!warningsFound) {
                missingProperties.add("warnings");
            }
            if (!itemCountFound) {
                missingProperties.add("itemsProcessed");
            }
            if (!failedItemCountFound) {
                missingProperties.add("itemsFailed");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

