/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.administration.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.administration.implementation.models.Error;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public final class FullBackupOperation
implements JsonSerializable<FullBackupOperation> {
    private String status;
    private String statusDetails;
    private Error error;
    private Long startTime;
    private Long endTime;
    private String jobId;
    private String azureStorageBlobContainerUri;

    public String getStatus() {
        return this.status;
    }

    public FullBackupOperation setStatus(String status) {
        this.status = status;
        return this;
    }

    public String getStatusDetails() {
        return this.statusDetails;
    }

    public FullBackupOperation setStatusDetails(String statusDetails) {
        this.statusDetails = statusDetails;
        return this;
    }

    public Error getError() {
        return this.error;
    }

    public FullBackupOperation setError(Error error) {
        this.error = error;
        return this;
    }

    public OffsetDateTime getStartTime() {
        if (this.startTime == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.startTime), ZoneOffset.UTC);
    }

    public FullBackupOperation setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime == null ? null : Long.valueOf(startTime.toEpochSecond());
        return this;
    }

    public OffsetDateTime getEndTime() {
        if (this.endTime == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.endTime), ZoneOffset.UTC);
    }

    public FullBackupOperation setEndTime(OffsetDateTime endTime) {
        this.endTime = endTime == null ? null : Long.valueOf(endTime.toEpochSecond());
        return this;
    }

    public String getJobId() {
        return this.jobId;
    }

    public FullBackupOperation setJobId(String jobId) {
        this.jobId = jobId;
        return this;
    }

    public String getAzureStorageBlobContainerUri() {
        return this.azureStorageBlobContainerUri;
    }

    public FullBackupOperation setAzureStorageBlobContainerUri(String azureStorageBlobContainerUri) {
        this.azureStorageBlobContainerUri = azureStorageBlobContainerUri;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status);
        jsonWriter.writeStringField("statusDetails", this.statusDetails);
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        jsonWriter.writeNumberField("startTime", (Number)this.startTime);
        jsonWriter.writeNumberField("endTime", (Number)this.endTime);
        jsonWriter.writeStringField("jobId", this.jobId);
        jsonWriter.writeStringField("azureStorageBlobContainerUri", this.azureStorageBlobContainerUri);
        return jsonWriter.writeEndObject();
    }

    public static FullBackupOperation fromJson(JsonReader jsonReader) throws IOException {
        return (FullBackupOperation)jsonReader.readObject(reader -> {
            FullBackupOperation deserializedFullBackupOperation = new FullBackupOperation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    deserializedFullBackupOperation.status = reader.getString();
                    continue;
                }
                if ("statusDetails".equals(fieldName)) {
                    deserializedFullBackupOperation.statusDetails = reader.getString();
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedFullBackupOperation.error = Error.fromJson(reader);
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedFullBackupOperation.startTime = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedFullBackupOperation.endTime = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("jobId".equals(fieldName)) {
                    deserializedFullBackupOperation.jobId = reader.getString();
                    continue;
                }
                if ("azureStorageBlobContainerUri".equals(fieldName)) {
                    deserializedFullBackupOperation.azureStorageBlobContainerUri = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFullBackupOperation;
        });
    }
}

