/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.administration.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.administration.implementation.models.Error;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public final class SelectiveKeyRestoreOperation
implements JsonSerializable<SelectiveKeyRestoreOperation> {
    private String status;
    private String statusDetails;
    private Error error;
    private String jobId;
    private Long startTime;
    private Long endTime;

    public String getStatus() {
        return this.status;
    }

    public SelectiveKeyRestoreOperation setStatus(String status) {
        this.status = status;
        return this;
    }

    public String getStatusDetails() {
        return this.statusDetails;
    }

    public SelectiveKeyRestoreOperation setStatusDetails(String statusDetails) {
        this.statusDetails = statusDetails;
        return this;
    }

    public Error getError() {
        return this.error;
    }

    public SelectiveKeyRestoreOperation setError(Error error) {
        this.error = error;
        return this;
    }

    public String getJobId() {
        return this.jobId;
    }

    public SelectiveKeyRestoreOperation setJobId(String jobId) {
        this.jobId = jobId;
        return this;
    }

    public OffsetDateTime getStartTime() {
        if (this.startTime == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.startTime), ZoneOffset.UTC);
    }

    public SelectiveKeyRestoreOperation setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime == null ? null : Long.valueOf(startTime.toEpochSecond());
        return this;
    }

    public OffsetDateTime getEndTime() {
        if (this.endTime == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.endTime), ZoneOffset.UTC);
    }

    public SelectiveKeyRestoreOperation setEndTime(OffsetDateTime endTime) {
        this.endTime = endTime == null ? null : Long.valueOf(endTime.toEpochSecond());
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status);
        jsonWriter.writeStringField("statusDetails", this.statusDetails);
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        jsonWriter.writeStringField("jobId", this.jobId);
        jsonWriter.writeNumberField("startTime", (Number)this.startTime);
        jsonWriter.writeNumberField("endTime", (Number)this.endTime);
        return jsonWriter.writeEndObject();
    }

    public static SelectiveKeyRestoreOperation fromJson(JsonReader jsonReader) throws IOException {
        return (SelectiveKeyRestoreOperation)jsonReader.readObject(reader -> {
            SelectiveKeyRestoreOperation deserializedSelectiveKeyRestoreOperation = new SelectiveKeyRestoreOperation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    deserializedSelectiveKeyRestoreOperation.status = reader.getString();
                    continue;
                }
                if ("statusDetails".equals(fieldName)) {
                    deserializedSelectiveKeyRestoreOperation.statusDetails = reader.getString();
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedSelectiveKeyRestoreOperation.error = Error.fromJson(reader);
                    continue;
                }
                if ("jobId".equals(fieldName)) {
                    deserializedSelectiveKeyRestoreOperation.jobId = reader.getString();
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedSelectiveKeyRestoreOperation.startTime = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedSelectiveKeyRestoreOperation.endTime = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSelectiveKeyRestoreOperation;
        });
    }
}

