/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates.implementation.models;

import com.azure.core.util.Base64Url;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;

public final class CertificateRestoreParameters
implements JsonSerializable<CertificateRestoreParameters> {
    private Base64Url certificateBundleBackup;

    public byte[] getCertificateBundleBackup() {
        if (this.certificateBundleBackup == null) {
            return null;
        }
        return this.certificateBundleBackup.decodedBytes();
    }

    public CertificateRestoreParameters setCertificateBundleBackup(byte[] certificateBundleBackup) {
        this.certificateBundleBackup = certificateBundleBackup == null ? null : Base64Url.encode((byte[])CoreUtils.clone((byte[])certificateBundleBackup));
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", Objects.toString(this.certificateBundleBackup, null));
        return jsonWriter.writeEndObject();
    }

    public static CertificateRestoreParameters fromJson(JsonReader jsonReader) throws IOException {
        return (CertificateRestoreParameters)jsonReader.readObject(reader -> {
            CertificateRestoreParameters deserializedCertificateRestoreParameters = new CertificateRestoreParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    deserializedCertificateRestoreParameters.certificateBundleBackup = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCertificateRestoreParameters;
        });
    }
}

