/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class IssuerParameters
implements JsonSerializable<IssuerParameters> {
    private String name;
    private String certificateType;
    private Boolean certificateTransparency;

    public String getName() {
        return this.name;
    }

    public IssuerParameters setName(String name) {
        this.name = name;
        return this;
    }

    public String getCertificateType() {
        return this.certificateType;
    }

    public IssuerParameters setCertificateType(String certificateType) {
        this.certificateType = certificateType;
        return this;
    }

    public Boolean isCertificateTransparency() {
        return this.certificateTransparency;
    }

    public IssuerParameters setCertificateTransparency(Boolean certificateTransparency) {
        this.certificateTransparency = certificateTransparency;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("cty", this.certificateType);
        jsonWriter.writeBooleanField("cert_transparency", this.certificateTransparency);
        return jsonWriter.writeEndObject();
    }

    public static IssuerParameters fromJson(JsonReader jsonReader) throws IOException {
        return (IssuerParameters)jsonReader.readObject(reader -> {
            IssuerParameters deserializedIssuerParameters = new IssuerParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedIssuerParameters.name = reader.getString();
                    continue;
                }
                if ("cty".equals(fieldName)) {
                    deserializedIssuerParameters.certificateType = reader.getString();
                    continue;
                }
                if ("cert_transparency".equals(fieldName)) {
                    deserializedIssuerParameters.certificateTransparency = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIssuerParameters;
        });
    }
}

