/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.certificates.models.CertificateKeyCurveName;
import com.azure.security.keyvault.certificates.models.CertificateKeyType;
import java.io.IOException;
import java.util.Objects;

public final class KeyProperties
implements JsonSerializable<KeyProperties> {
    private Boolean exportable;
    private Integer keySize;
    private Boolean reuseKey;
    private CertificateKeyType kty;
    private CertificateKeyCurveName crv;

    public Boolean isExportable() {
        return this.exportable;
    }

    public KeyProperties setExportable(Boolean exportable) {
        this.exportable = exportable;
        return this;
    }

    public Integer getKeySize() {
        return this.keySize;
    }

    public KeyProperties setKeySize(Integer keySize) {
        this.keySize = keySize;
        return this;
    }

    public Boolean isReuseKey() {
        return this.reuseKey;
    }

    public KeyProperties setReuseKey(Boolean reuseKey) {
        this.reuseKey = reuseKey;
        return this;
    }

    public CertificateKeyType getKty() {
        return this.kty;
    }

    public KeyProperties setKty(CertificateKeyType kty) {
        this.kty = kty;
        return this;
    }

    public CertificateKeyCurveName getCrv() {
        return this.crv;
    }

    public KeyProperties setCrv(CertificateKeyCurveName crv) {
        this.crv = crv;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("exportable", this.exportable);
        jsonWriter.writeNumberField("key_size", (Number)this.keySize);
        jsonWriter.writeBooleanField("reuse_key", this.reuseKey);
        jsonWriter.writeStringField("kty", Objects.toString((Object)this.kty, null));
        jsonWriter.writeStringField("crv", Objects.toString((Object)this.crv, null));
        return jsonWriter.writeEndObject();
    }

    public static KeyProperties fromJson(JsonReader jsonReader) throws IOException {
        return (KeyProperties)jsonReader.readObject(reader -> {
            KeyProperties deserializedKeyProperties = new KeyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("exportable".equals(fieldName)) {
                    deserializedKeyProperties.exportable = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("key_size".equals(fieldName)) {
                    deserializedKeyProperties.keySize = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("reuse_key".equals(fieldName)) {
                    deserializedKeyProperties.reuseKey = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("kty".equals(fieldName)) {
                    deserializedKeyProperties.kty = CertificateKeyType.fromString(reader.getString());
                    continue;
                }
                if ("crv".equals(fieldName)) {
                    deserializedKeyProperties.crv = CertificateKeyCurveName.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyProperties;
        });
    }
}

