/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.certificates.models.CertificateKeyUsage;
import com.azure.security.keyvault.certificates.models.SubjectAlternativeNames;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public final class X509CertificateProperties
implements JsonSerializable<X509CertificateProperties> {
    private String subject;
    private List<String> ekus;
    private SubjectAlternativeNames subjectAlternativeNames;
    private List<CertificateKeyUsage> keyUsage;
    private Integer validityInMonths;

    public String getSubject() {
        return this.subject;
    }

    public X509CertificateProperties setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public List<String> getEkus() {
        return this.ekus;
    }

    public X509CertificateProperties setEkus(List<String> ekus) {
        this.ekus = ekus;
        return this;
    }

    public SubjectAlternativeNames getSubjectAlternativeNames() {
        return this.subjectAlternativeNames;
    }

    public X509CertificateProperties setSubjectAlternativeNames(SubjectAlternativeNames subjectAlternativeNames) {
        this.subjectAlternativeNames = subjectAlternativeNames;
        return this;
    }

    public List<CertificateKeyUsage> getKeyUsage() {
        return this.keyUsage;
    }

    public X509CertificateProperties setKeyUsage(List<CertificateKeyUsage> keyUsage) {
        this.keyUsage = keyUsage;
        return this;
    }

    public Integer getValidityInMonths() {
        return this.validityInMonths;
    }

    public X509CertificateProperties setValidityInMonths(Integer validityInMonths) {
        this.validityInMonths = validityInMonths;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("subject", this.subject);
        jsonWriter.writeArrayField("ekus", this.ekus, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("sans", (JsonSerializable)this.subjectAlternativeNames);
        jsonWriter.writeArrayField("key_usage", this.keyUsage, (writer, element) -> writer.writeString(Objects.toString(element, null)));
        jsonWriter.writeNumberField("validity_months", (Number)this.validityInMonths);
        return jsonWriter.writeEndObject();
    }

    public static X509CertificateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (X509CertificateProperties)jsonReader.readObject(reader -> {
            X509CertificateProperties deserializedX509CertificateProperties = new X509CertificateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("subject".equals(fieldName)) {
                    deserializedX509CertificateProperties.subject = reader.getString();
                    continue;
                }
                if ("ekus".equals(fieldName)) {
                    List ekus;
                    deserializedX509CertificateProperties.ekus = ekus = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("sans".equals(fieldName)) {
                    deserializedX509CertificateProperties.subjectAlternativeNames = SubjectAlternativeNames.fromJson(reader);
                    continue;
                }
                if ("key_usage".equals(fieldName)) {
                    List keyUsage;
                    deserializedX509CertificateProperties.keyUsage = keyUsage = reader.readArray(reader1 -> CertificateKeyUsage.fromString(reader1.getString()));
                    continue;
                }
                if ("validity_months".equals(fieldName)) {
                    deserializedX509CertificateProperties.validityInMonths = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedX509CertificateProperties;
        });
    }
}

