/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.core.query;

import java.util.Objects;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;

public class CosmosPageRequest
extends PageRequest {
    private static final long serialVersionUID = 6093304300037688375L;
    private long offset;
    private final String requestContinuation;

    public CosmosPageRequest(int page, int size, String requestContinuation) {
        super(page, size, Sort.unsorted());
        this.requestContinuation = requestContinuation;
    }

    public CosmosPageRequest(int page, int size, String requestContinuation, Sort sort) {
        super(page, size, sort);
        this.requestContinuation = requestContinuation;
    }

    private CosmosPageRequest(long offset, int page, int size, String requestContinuation) {
        super(page, size, Sort.unsorted());
        this.offset = offset;
        this.requestContinuation = requestContinuation;
    }

    private CosmosPageRequest(long offset, int page, int size, String requestContinuation, Sort sort) {
        super(page, size, sort);
        this.offset = offset;
        this.requestContinuation = requestContinuation;
    }

    public static CosmosPageRequest of(int page, int size, String requestContinuation, Sort sort) {
        return new CosmosPageRequest(0L, page, size, requestContinuation, sort);
    }

    public static CosmosPageRequest of(long offset, int page, int size, String requestContinuation, Sort sort) {
        return new CosmosPageRequest(offset, page, size, requestContinuation, sort);
    }

    public PageRequest next() {
        return new CosmosPageRequest(this.offset + (long)this.getPageSize(), this.getPageNumber() + 1, this.getPageSize(), this.requestContinuation, this.getSort());
    }

    public long getOffset() {
        return this.offset;
    }

    public String getRequestContinuation() {
        return this.requestContinuation;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.requestContinuation != null ? this.requestContinuation.hashCode() : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CosmosPageRequest)) {
            return false;
        }
        CosmosPageRequest that = (CosmosPageRequest)((Object)obj);
        boolean continuationTokenEquals = Objects.equals(this.requestContinuation, that.requestContinuation);
        return continuationTokenEquals && super.equals((Object)that);
    }
}

